% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{extract.enumerate_parsimony}
\alias{extract.enumerate_parsimony}
\title{Extract the result of \code{enumerate_parsimony} at a node.}
\usage{
\method{extract}{enumerate_parsimony}(x, node = attr(x$allocations, "ntaxa") +
  1, what = c("solutions", "number", "cost"), ...)
}
\arguments{
\item{x}{an object of class "\code{enumerate_parsimony}",
result of function \code{\link{enumerate_parsimony}}.}

\item{node}{the node where to retrive the parsimony number. Default to the
root of the tree.}

\item{what}{the quantity to retrieve. Either "solutions" for the full
solutions, "number" for the number of solutions, or "cost" for the minimal
cost of a solution. Default to "solutions"}

\item{...}{unused}
}
\value{
A matrix with ntaxa + nNode columns, and as many rows as the number of
possible parsimonious reconstructions.
}
\description{
\code{extract.enumerate_parsimony} returns a matrix containing all the
possible regime allocations for the nodes of a given subtree.
}
\seealso{
\code{\link{enumerate_parsimony}}, \code{\link{plot.enumerate_parsimony}}
}
