% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_EM.R
\name{lasso_regression_K_fixed.glmnet_multivariate}
\alias{lasso_regression_K_fixed.glmnet_multivariate}
\title{Do a lasso regression with the number of non-zero variables fixed.}
\usage{
lasso_regression_K_fixed.glmnet_multivariate(Yp, Xp, K, root = NULL,
  penscale = rep(1, ncol(Xp)), K_lag = 0)
}
\arguments{
\item{Yp}{(transformed) data}

\item{Xp}{(transformed) matrix of regression}

\item{K}{number of non-zero components allowed}
}
\value{
E0.gauss the intercept (value at the root)

shifts.gauss the list of shifts found on the branches
}
\description{
\code{lasso_regression_K_fixed} does the following regression :
||Yp-Xp.delta|| + lambda |delta|_1 using the function \code{glmnet::glmnet} of 
package \code{glmnet}, where delta is a vector representing the shifts 
occuring on the branches. It does a gauss lasso regression using function 
\code{lm} on top of it. This function is used in functions 
\code{init.EM.lasso}, \code{segmentation.OU.specialCase.lasso}, ...
}
\details{
lambda is choosen so that delta has the right number of non zero components.
If not possible, either temporaly raise the number of shifts and then select
only the shifts with the highest modulus, or if not possible, throw an error.
}
\keyword{internal}
