% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M_step.R
\name{optimize_costs_given_shift_position.OU.specialCase}
\alias{optimize_costs_given_shift_position.OU.specialCase}
\title{Minimization of the sum of costs, given the shift position.}
\usage{
optimize_costs_given_shift_position.OU.specialCase(phylo, conditional_law_X,
  selection.strength, shifts_edges, ...)
}
\arguments{
\item{phylo}{a phylogenetic tree}

\item{conditional_law_X}{moments of the conditional law of X given Y, result
of function \code{compute_M.OU.specialCase}}

\item{selection.strength}{the selection strength}

\item{shifts_edges}{the vector of the position of the shifts on the tree}
}
\value{
List containing : beta_0 : the optimal value at the root
                          shifts : list containing the computed tau and delta
                          costs : vector of costs
}
\description{
\code{optimize_costs_given_shift_position.OU.specialCase} minimize the sum of
costs when the shift position is fixed.
}
\details{
This function find the regimes of each node using function 
\code{allocate_regimes_from_shifts} and optimize the sum of costs, computed 
using function \code{compute_diff_exp.OU}, in the values of the optimal values
betas (using a close formula). It then goes back to a shift expression of the
problem using function \code{compute_shifts_from_betas}.
}
\keyword{internal}
