% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simul_process}
\alias{simul_process}
\alias{simul_process.params_process}
\alias{simul_process.PhyloEM}
\title{Simulate a Stochastic Process on a tree}
\usage{
simul_process(x, ...)

\method{simul_process}{params_process}(x, phylo, simulate_random = TRUE,
  checks = TRUE, U_tree = NULL, times_shared = NULL, ...)

\method{simul_process}{PhyloEM}(x, simulate_random = TRUE, checks = TRUE,
  U_tree = NULL, times_shared = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{\link{params_process}} or \code{\link{PhyloEM}}.}

\item{...}{for a \code{PhyloEM} object, further arguments to be passed on to
\code{\link{params_process.PhyloEM}} (to choose which parameters to extract from
the results, see documentation of this function).}

\item{phylo}{a phylogenetic tree, class \code{\link[ape]{phylo}}.}

\item{simulate_random}{set to FALSE if only the expected values are needed
(and not the random sample). Default to TRUE.}

\item{checks}{whether to check the entry parameters for consistency. Default 
to TRUE.}

\item{U_tree}{optional, full incidence matrix of the tree, result of function
\code{\link{incidence.matrix.full}}. Can be specified to avoid extra computations.}

\item{times_shared}{optional, times of shared ancestry of all nodes and tips,
result of function \code{\link{compute_times_ca}}. Can be specified to avoid extra
computations.}
}
\value{
An S3 object of class \code{simul_process}. This contains:
\describe{
 \item{sim_traits}{an array with dimensions p x nNodes x 2 (BM)
 or p x nNodes x 3 (OU). For each trait t, 1 <= t <= p, sim_traits[t, , ] has
 tree columns, containing respectively the simulated state,
 expected value and optimal value for all the nodes.}
 \item{phylo}{the phylogenetic tree used for the simulations (class \code{phylo}).}
 \item{params}{the parameters used for the simulations
 (class \code{params_proces}).}
 }
}
\description{
\code{simulate} simulate a stochastic process on a tree.
}
\section{Methods (by class)}{
\itemize{
\item \code{params_process}: \code{\link{params_process}} object

\item \code{PhyloEM}: \code{\link{PhyloEM}} object
}}

\seealso{
\code{\link{params_process}}, \code{\link{PhyloEM}}
}
