% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markPAI.R
\name{markPAI}
\alias{markPAI}
\title{Mark Physical Activity Intensity (PAI) Level}
\usage{
markPAI(data, cts = getOption("pa.cts"), markingString = "w",
  breaks = c(-Inf, 100, 760, 2020, Inf), labels = c("sedentary", "light",
  "moderate", "vigorous"))
}
\arguments{
\item{data}{Data with classified wear (nonwear) status by
\code{\link{wearingMarking}}.}

\item{cts}{The name of the counts column. The default is \dQuote{axis1}.}

\item{markingString}{Option for summarizing wear (markingString = \dQuote{w}) or
nonwear time (markingString = \dQuote{nw}).}

\item{breaks}{A numeric vector of cut-points. The default cut-points are based on
Matthews \emph{et al.} (2016).}

\item{labels}{A character vector labelling intensity levels.}
}
\value{
A data frame with an additional PAI-level column.
}
\description{
This function adds a physical activity intensity level variable \dQuote{pai} to the
source dataset. The \dQuote{pai} is an ordered factor variable. It will be NA for
nonwear times.
}
\examples{
data(dataSec)

mydata1m = dataCollapser(dataSec, TS = "TimeStamp", col = "counts", by = 60)

data1m = wearingMarking(dataset = mydata1m,
                       perMinuteCts = 1,
                       cts = "counts")

markPAI(data = data1m, cts = 'counts')[1:10,]
}
\references{
Matthews CE, Keadle SK, Troiano RP, Kahle L, Koster A, Brychta R, 
Van Domelen D, Caserotti P, Chen KY, Harris TB, Berrigan D. 
Accelerometer-measured dose-response for physical activity, sedentary time, and mortality in US adults.
Am J Clin Nutr. 2016 Nov;104(5):1424-1432.
}
\author{
Cole Beck \email{cole.beck@vumc.org},
Leena Choi \email{leena.choi@Vanderbilt.Edu}
}
