% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Circle.R
\name{Circle}
\alias{Circle}
\title{R6 class representing a circle}
\description{
A circle is given by a center and a radius,
named \code{center} and \code{radius}.
}
\examples{

## ------------------------------------------------
## Method `Circle$new`
## ------------------------------------------------

circ <- Circle$new(c(1,1), 1)
circ
circ$center
circ$center <- c(0,0)
circ

## ------------------------------------------------
## Method `Circle$print`
## ------------------------------------------------

Circle$new(c(0,0), 2)

## ------------------------------------------------
## Method `Circle$diameter`
## ------------------------------------------------

circ <- Circle$new(c(1,1), 5)
diams <- lapply(c(0, pi/3, 2*pi/3), circ$diameter)
plot(NULL, type="n", asp=1, xlim = c(-4,6), ylim = c(-5,7),
     xlab = NA, ylab = NA)
draw(circ, lwd = 2, col = "yellow")
invisible(lapply(diams, draw, col = "blue"))

## ------------------------------------------------
## Method `Circle$tangent`
## ------------------------------------------------

circ <- Circle$new(c(1,1), 5)
tangents <- lapply(c(0, pi/3, 2*pi/3, pi, 4*pi/3, 5*pi/3), circ$tangent)
plot(NULL, type="n", asp=1, xlim = c(-4,6), ylim = c(-5,7),
     xlab = NA, ylab = NA)
draw(circ, lwd = 2, col = "yellow")
invisible(lapply(tangents, draw, col = "blue"))

## ------------------------------------------------
## Method `Circle$orthogonalThroughTwoPointsOnCircle`
## ------------------------------------------------

# hyperbolic triangle
circ <- Circle$new(c(5,5), 3)
arc1 <- circ$orthogonalThroughTwoPointsOnCircle(0, 2*pi/3, arc = TRUE)
arc2 <- circ$orthogonalThroughTwoPointsOnCircle(2*pi/3, 4*pi/3, arc = TRUE)
arc3 <- circ$orthogonalThroughTwoPointsOnCircle(4*pi/3, 0, arc = TRUE)
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type = "n", asp = 1, xlim = c(2,8), ylim = c(2,8))
draw(circ)
draw(arc1, col = "red", lwd = 2)
draw(arc2, col = "green", lwd = 2)
draw(arc3, col = "blue", lwd = 2)
par(opar)

## ------------------------------------------------
## Method `Circle$orthogonalThroughTwoPointsWithinCircle`
## ------------------------------------------------

circ <- Circle$new(c(0,0),3)
P1 <- c(1,1); P2 <- c(1, 2)
ocirc <- circ$orthogonalThroughTwoPointsWithinCircle(P1, P2)
arc <- circ$orthogonalThroughTwoPointsWithinCircle(P1, P2, arc = TRUE)
plot(0, 0, type = "n", asp = 1, xlab = NA, ylab = NA,
     xlim = c(-3, 4), ylim = c(-3, 4))
draw(circ, lwd = 2)
draw(ocirc, lty = "dashed", lwd = 2)
draw(arc, lwd = 3, col = "blue")
}
\seealso{
\code{\link{radicalCenter}} for the radical center of three circles.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{center}}{get or set the center}

\item{\code{radius}}{get or set the radius}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Circle$new()}}
\item \href{#method-print}{\code{Circle$print()}}
\item \href{#method-pointFromAngle}{\code{Circle$pointFromAngle()}}
\item \href{#method-diameter}{\code{Circle$diameter()}}
\item \href{#method-tangent}{\code{Circle$tangent()}}
\item \href{#method-tangentsThroughExternalPoint}{\code{Circle$tangentsThroughExternalPoint()}}
\item \href{#method-isEqual}{\code{Circle$isEqual()}}
\item \href{#method-isDifferent}{\code{Circle$isDifferent()}}
\item \href{#method-isOrthogonal}{\code{Circle$isOrthogonal()}}
\item \href{#method-angle}{\code{Circle$angle()}}
\item \href{#method-includes}{\code{Circle$includes()}}
\item \href{#method-orthogonalThroughTwoPointsOnCircle}{\code{Circle$orthogonalThroughTwoPointsOnCircle()}}
\item \href{#method-orthogonalThroughTwoPointsWithinCircle}{\code{Circle$orthogonalThroughTwoPointsWithinCircle()}}
\item \href{#method-power}{\code{Circle$power()}}
\item \href{#method-radicalCenter}{\code{Circle$radicalCenter()}}
\item \href{#method-radicalAxis}{\code{Circle$radicalAxis()}}
\item \href{#method-rotate}{\code{Circle$rotate()}}
\item \href{#method-translate}{\code{Circle$translate()}}
\item \href{#method-invert}{\code{Circle$invert()}}
\item \href{#method-asEllipse}{\code{Circle$asEllipse()}}
\item \href{#method-randomPoints}{\code{Circle$randomPoints()}}
\item \href{#method-clone}{\code{Circle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Circle} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$new(center, radius)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{center}}{the center}

\item{\code{radius}}{the radius}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Circle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{circ <- Circle$new(c(1,1), 1)
circ
circ$center
circ$center <- c(0,0)
circ
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Show instance of a circle object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Circle$new(c(0,0), 2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pointFromAngle"></a>}}
\if{latex}{\out{\hypertarget{method-pointFromAngle}{}}}
\subsection{Method \code{pointFromAngle()}}{
Get a point on the reference circle from its polar angle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$pointFromAngle(alpha, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{a number, the angle}

\item{\code{degrees}}{logical, whether \code{alpha} is given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The point on the circle with polar angle \code{alpha}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-diameter"></a>}}
\if{latex}{\out{\hypertarget{method-diameter}{}}}
\subsection{Method \code{diameter()}}{
Diameter of the reference circle for a given polar angle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$diameter(alpha)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{an angle in radians, there is one diameter for each value of
\code{alpha} modulo \code{pi}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A segment (\code{Line} object).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{circ <- Circle$new(c(1,1), 5)
diams <- lapply(c(0, pi/3, 2*pi/3), circ$diameter)
plot(NULL, type="n", asp=1, xlim = c(-4,6), ylim = c(-5,7),
     xlab = NA, ylab = NA)
draw(circ, lwd = 2, col = "yellow")
invisible(lapply(diams, draw, col = "blue"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tangent"></a>}}
\if{latex}{\out{\hypertarget{method-tangent}{}}}
\subsection{Method \code{tangent()}}{
Tangent of the reference circle at a given polar angle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$tangent(alpha)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{an angle in radians, there is one tangent for each value of
\code{alpha} modulo \code{2*pi}}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{circ <- Circle$new(c(1,1), 5)
tangents <- lapply(c(0, pi/3, 2*pi/3, pi, 4*pi/3, 5*pi/3), circ$tangent)
plot(NULL, type="n", asp=1, xlim = c(-4,6), ylim = c(-5,7),
     xlab = NA, ylab = NA)
draw(circ, lwd = 2, col = "yellow")
invisible(lapply(tangents, draw, col = "blue"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tangentsThroughExternalPoint"></a>}}
\if{latex}{\out{\hypertarget{method-tangentsThroughExternalPoint}{}}}
\subsection{Method \code{tangentsThroughExternalPoint()}}{
Return the two tangents of the reference circle passing
through an external point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$tangentsThroughExternalPoint(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point external to the reference circle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of two \code{Line} objects, the two tangents; the
tangency points are in the \code{B} field of the lines.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isEqual"></a>}}
\if{latex}{\out{\hypertarget{method-isEqual}{}}}
\subsection{Method \code{isEqual()}}{
Check whether the reference circle equals another circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$isEqual(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isDifferent"></a>}}
\if{latex}{\out{\hypertarget{method-isDifferent}{}}}
\subsection{Method \code{isDifferent()}}{
Check whether the reference circle differs from another circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$isDifferent(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isOrthogonal"></a>}}
\if{latex}{\out{\hypertarget{method-isOrthogonal}{}}}
\subsection{Method \code{isOrthogonal()}}{
Check whether the reference circle is orthogonal to a
given circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$isOrthogonal(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angle"></a>}}
\if{latex}{\out{\hypertarget{method-angle}{}}}
\subsection{Method \code{angle()}}{
Angle between the reference circle and a given circle,
if they intersect.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$angle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-includes"></a>}}
\if{latex}{\out{\hypertarget{method-includes}{}}}
\subsection{Method \code{includes()}}{
Check whether a point belongs to the reference circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$includes(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-orthogonalThroughTwoPointsOnCircle"></a>}}
\if{latex}{\out{\hypertarget{method-orthogonalThroughTwoPointsOnCircle}{}}}
\subsection{Method \code{orthogonalThroughTwoPointsOnCircle()}}{
Orthogonal circle passing through two points on the reference circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$orthogonalThroughTwoPointsOnCircle(alpha1, alpha2, arc = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha1, alpha2}}{two angles defining two points on the reference circle}

\item{\code{arc}}{logical, whether to return only the arc at the interior of the
reference circle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object if \code{arc=FALSE}, an \code{Arc} object
if \code{arc=TRUE}, or a \code{Line} object: the diameter
of the reference circle defined by the two points in case when the two
angles differ by \code{pi}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# hyperbolic triangle
circ <- Circle$new(c(5,5), 3)
arc1 <- circ$orthogonalThroughTwoPointsOnCircle(0, 2*pi/3, arc = TRUE)
arc2 <- circ$orthogonalThroughTwoPointsOnCircle(2*pi/3, 4*pi/3, arc = TRUE)
arc3 <- circ$orthogonalThroughTwoPointsOnCircle(4*pi/3, 0, arc = TRUE)
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type = "n", asp = 1, xlim = c(2,8), ylim = c(2,8))
draw(circ)
draw(arc1, col = "red", lwd = 2)
draw(arc2, col = "green", lwd = 2)
draw(arc3, col = "blue", lwd = 2)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-orthogonalThroughTwoPointsWithinCircle"></a>}}
\if{latex}{\out{\hypertarget{method-orthogonalThroughTwoPointsWithinCircle}{}}}
\subsection{Method \code{orthogonalThroughTwoPointsWithinCircle()}}{
Orthogonal circle passing through two points within the reference circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$orthogonalThroughTwoPointsWithinCircle(P1, P2, arc = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P1, P2}}{two distinct points in the interior of the reference circle}

\item{\code{arc}}{logical, whether to return the arc joining the two points
instead of the circle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object or an \code{Arc} object,
or a \code{Line} object if the two points are on a diameter.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{circ <- Circle$new(c(0,0),3)
P1 <- c(1,1); P2 <- c(1, 2)
ocirc <- circ$orthogonalThroughTwoPointsWithinCircle(P1, P2)
arc <- circ$orthogonalThroughTwoPointsWithinCircle(P1, P2, arc = TRUE)
plot(0, 0, type = "n", asp = 1, xlab = NA, ylab = NA,
     xlim = c(-3, 4), ylim = c(-3, 4))
draw(circ, lwd = 2)
draw(ocirc, lty = "dashed", lwd = 2)
draw(arc, lwd = 3, col = "blue")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-power"></a>}}
\if{latex}{\out{\hypertarget{method-power}{}}}
\subsection{Method \code{power()}}{
Power of a point with respect to the reference circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$power(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-radicalCenter"></a>}}
\if{latex}{\out{\hypertarget{method-radicalCenter}{}}}
\subsection{Method \code{radicalCenter()}}{
Radical center of two circles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$radicalCenter(circ2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ2}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-radicalAxis"></a>}}
\if{latex}{\out{\hypertarget{method-radicalAxis}{}}}
\subsection{Method \code{radicalAxis()}}{
Radical axis of two circles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$radicalAxis(circ2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ2}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-rotate}{}}}
\subsection{Method \code{rotate()}}{
Rotate the reference circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$rotate(alpha, O, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{angle of rotation}

\item{\code{O}}{center of rotation}

\item{\code{degrees}}{logical, whether \code{alpha} is given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-translate"></a>}}
\if{latex}{\out{\hypertarget{method-translate}{}}}
\subsection{Method \code{translate()}}{
Translate the reference circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$translate(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{the vector of translation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-invert"></a>}}
\if{latex}{\out{\hypertarget{method-invert}{}}}
\subsection{Method \code{invert()}}{
Invert the reference circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$invert(inversion)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inversion}}{an \code{Inversion} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object or a \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asEllipse"></a>}}
\if{latex}{\out{\hypertarget{method-asEllipse}{}}}
\subsection{Method \code{asEllipse()}}{
Convert the reference circle to an \code{Ellipse} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$asEllipse()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-randomPoints"></a>}}
\if{latex}{\out{\hypertarget{method-randomPoints}{}}}
\subsection{Method \code{randomPoints()}}{
Random points on or in the reference circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$randomPoints(n, where = "in")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{an integer, the desired number of points}

\item{\code{where}}{\code{"in"} to generate inside the circle,
\code{"on"} to generate on the circle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The generated points in a two columns matrix with \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
