context("Mid-circles")

test_that("midCircles function", {
  # two congruent circles which do not intersect each other
  circ1 <- Circle$new(center = c(1,2), radius = 3)
  circ2 <- Circle$new(center = c(14,15), radius = 3)
  mc <- midCircles(circ1, circ2)
  expect_is(mc, "Line")
  R <- Reflection$new(mc)
  expect_true(R$reflectCircle(circ1)$isEqual(circ2))
  expect_true(R$reflectCircle(circ2)$isEqual(circ1))
  # two congruent circles which intersect each other
  circ1 <- Circle$new(center = c(1,2), radius = 3)
  circ2 <- Circle$new(center = c(2,2), radius = 3)
  mc <- midCircles(circ1, circ2)
  expect_is(mc, "list")
  R <- Reflection$new(mc$C2)
  expect_true(R$reflectCircle(circ1)$isEqual(circ2))
  expect_true(R$reflectCircle(circ2)$isEqual(circ1))
  iota <- inversionFromCircle(mc$C1)
  expect_true(iota$invertCircle(circ1)$isEqual(circ2))
  expect_true(iota$invertCircle(circ2)$isEqual(circ1))
  # two tangent congruent circles
  circ1 <- Circle$new(center = c(1,2), radius = 3)
  circ2 <- Circle$new(center = c(7,2), radius = 3)
  mc <- midCircles(circ1, circ2)
  expect_is(mc, "Line")
  R <- Reflection$new(mc)
  expect_true(R$reflectCircle(circ1)$isEqual(circ2))
  expect_true(R$reflectCircle(circ2)$isEqual(circ1))
  # two non-intersecting circles outside each other
  circ1 <- Circle$new(c(0,2), 3)
  circ2 <- Circle$new(c(4,5), 1)
  mc <- midCircles(circ1, circ2)
  expect_is(mc, "Circle")
  iota <- inversionFromCircle(mc)
  expect_true(iota$invertCircle(circ1)$isEqual(circ2))
  expect_true(iota$invertCircle(circ2)$isEqual(circ1))
  # two non-intersecting circles, one inside the other
  circ1 <- Circle$new(c(0,0), 3)
  circ2 <- Circle$new(c(0.7,1), 0.7)
  mc <- midCircles(circ1, circ2)
  expect_is(mc, "Circle")
  iota <- inversionFromCircle(mc)
  expect_true(iota$invertCircle(circ1)$isEqual(circ2))
  expect_true(iota$invertCircle(circ2)$isEqual(circ1))
  # two intersecting circles
  circ1 <- Circle$new(c(5,4), 2)
  circ2 <- Circle$new(c(8,5), 3)
  mc <- midCircles(circ1, circ2)
  expect_is(mc, "list")
  iota <- inversionFromCircle(mc$C1)
  expect_true(iota$invertCircle(circ1)$isEqual(circ2))
  expect_true(iota$invertCircle(circ2)$isEqual(circ1))
  iota <- inversionFromCircle(mc$C2)
  expect_true(iota$invertCircle(circ1)$isEqual(circ2))
  expect_true(iota$invertCircle(circ2)$isEqual(circ1))
  # two tangent circles, externally
  circ1 <- Circle$new(c(5,4), 2)
  circ2 <- Circle$new(c(8,4), 1)
  mc <- midCircles(circ1, circ2)
  expect_is(mc, "Circle")
  iota <- inversionFromCircle(mc)
  expect_true(iota$invertCircle(circ1)$isEqual(circ2))
  expect_true(iota$invertCircle(circ2)$isEqual(circ1))
  # two tangent circles, internally
  circ1 <- Circle$new(c(5,4), 2)
  circ2 <- Circle$new(c(6,4), 1)
  mc <- midCircles(circ1, circ2)
  expect_is(mc, "Circle")
  iota <- inversionFromCircle(mc)
  expect_true(iota$invertCircle(circ1)$isEqual(circ2))
  expect_true(iota$invertCircle(circ2)$isEqual(circ1))
})
