% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_phylogenetic_trees_plot.R
\name{VDJ_phylogenetic_trees_plot}
\alias{VDJ_phylogenetic_trees_plot}
\title{Function to plot phylogenetic trees obtained from VDJ_phylogenetic_trees}
\usage{
VDJ_phylogenetic_trees_plot(
  tree.dfs,
  color.by,
  size.by,
  shape.by,
  specific.leaf.colors
)
}
\arguments{
\item{tree.dfs}{nested list of tidytree dataframes obtained from VDJ_phylogenetic_trees with output.format='tree.df.list'. tree.dfs[[1]][[2]] represent a tree dataframe for the first sample, second clonotype.}

\item{color.by}{string - VDJ or tree df column name which will be used to color the tree nodes.}

\item{size.by}{string or NULL - VDJ or tree df column name which determines the node size. If NULL, node sizes will be equal.}

\item{shape.by}{string or NULL - VDJ or tree df column name which determines the node shape. If NULL, node sizes will be equal.}

\item{specific.leaf.colors}{named list or NULL - if NULL, colors will be automatically selected for each node according to its color.by value.}
}
\value{
nested list of ggtree plot objects for each sample and each clonotype.
}
\description{
!Requires the ggtree package to be loaded! Plots trees from function VDJ_phylogenetic_trees
}
\examples{
\dontrun{
VDJ_phylogenetic_trees_plot(tree.dfs,color.by='clonotype_id', size.by='sequence_frequency')
}
}
