% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_VJ_usage_circos.R
\name{VDJ_VJ_usage_circos}
\alias{VDJ_VJ_usage_circos}
\title{Makes a Circos plot from the VDJ_analyze output. Connects the V gene with the corresponding J gene for each clonotype.}
\usage{
VDJ_VJ_usage_circos(
  VDJ,
  A.or.B,
  label.threshold,
  cell.level,
  c.threshold,
  clonotype.per.gene.threshold,
  c.count,
  platypus.version,
  filter1H1L
)
}
\arguments{
\item{VDJ}{The output of the VDJ_GEX_integrate function (Platypus platypus.version v2). A list of data frames for each sample containing the clonotype information and cluster membership information. For Platypus platypus.version v3, the VDJ output of the VDJ_GEX_matrix function (VDJ_GEX_matrix.output[[1]]) has to be supplied.}

\item{A.or.B}{Determines whether to plot the V J gene pairing of the alpha or beta chain. "A", "B" or "both" as possible inputs. Default: "both".}

\item{label.threshold}{Minimal amount of clonotypes per gene neccessary to add a gene label to the sector. Default: 0.}

\item{cell.level}{Logical, defines whether weight of connection should be based on number of clonotypes of number of cells. Default: number of clonotypes.}

\item{c.threshold}{Only clonotypes are considered with a frequency higher then c.threshold. Allows to filter for only highly expanded clonotypes.}

\item{clonotype.per.gene.threshold}{How many clonotypes are required to plot a sector for a gene. Filters the rows and colums of the final adjacency matrix.}

\item{c.count}{Show clonotype or cell count on Circos plot. Default = T.}

\item{platypus.version}{Which platypus.version of platypus is being used. Default = v3. Set to v3 if VDJ_GEX_matrix.output[[1]] is used}

\item{filter1H1L}{Whether to filter the input VDJ in "v3" to only include cells with 1 VDJ and 1 VJ chain. Defaults to TRUE}
}
\value{
Returns list of plots. The first n elements contain the circos plot of the n datasets from the VDJ.analyze function. The n+1 element contains a list of the n adjancey matrices for each dataset.
}
\description{
Makes a Circos plot from the VDJ_analyze output. Connects the V gene with the corresponding J gene for each clonotype.
}
\examples{
\dontrun{
 plots <- VDJ_VJ_usage_circos(VDJ = Platypus::small_vgm[[1]], platypus.version = "v3",
 cell.level = TRUE)
}
}
