% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbForests_SubRepertoiresByCells.R
\name{AbForests_SubRepertoiresByCells}
\alias{AbForests_SubRepertoiresByCells}
\title{Split single cell immune repertoire into sub-repertoires by isotype based on number of B cells}
\usage{
AbForests_SubRepertoiresByCells(list)
}
\arguments{
\item{list}{a list of data.frames. Each data.frame represents a clone lineage and separates initial input data into subsets of networks.}
}
\value{
list a nested list of 5 sub-lists of data.frames. Each sub-list corresponds to the set of networks, in which a majority isotype is specifyied. list[[1]] or list$list_IGHG contains the networks, in data.frame format, with more IGG isotypes, list[[2]] or list$list_IGHA contains the networks, in data.frame format, with more IGA isotypes, list[[3]] or list$list_IGHM contains the networks, in data.frame format, with more IGM isotypes, list[[4]] or list$list_IGAG contains the networks, in data.frame format, with a tie in IGA and IGG isotypes and list[[5]] or list$list_other contains the networks, in data.frame format, with other isotypes apart from the aforementioned combinations.
}
\description{
SubRepertoiresByCells separates the single cell immune repertoire into 5 sub-repertoires taking into account the number of cells. The goal is to determine the majority isotype per each network in the immune repertoire. Therefore, each sub-repertoire is dominated by isotype IGG, IGA, IGM, other and if there is an equal number of IGA and IGG isotypes in a network, IGA-IGG category exists respectively. In particular, in case there exists a tie in the number of IGA and IGM, the network is considered to contain IGA as majority isotype, while the same number of IGG and IGM in the network categorize this network as containing IGG as majority isotype. The function receives the output of CsvToDf or original data and can be given as input to ConvertStructure function.
}
\examples{
\dontrun{
SubRepertoiresByCells(list)
}
}
\seealso{
ConvertStructure, CsvToDf
}
