% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_overlap.R
\name{AntibodyForests_overlap}
\alias{AntibodyForests_overlap}
\title{Edge overlap heatmaps for a set of AntibodyForests sequence similarity networks or minimum spanning trees.}
\usage{
AntibodyForests_overlap(trees, group.by, method)
}
\arguments{
\item{trees}{nested list of AntibodyForests objects, as obtained from the AntibodyForests function.}

\item{group.by}{vector of strings - node features to group the edges by (counts edge incidence across the unique feature values for the specified node feature).}

\item{method}{string - overlap calculator: 'overlap' for unique/public edge counts across the feature values, 'jaccard' to calculate the Jaccard index.}
}
\value{
Edge overlap heatmaps for the specific overlap metric/method.
}
\description{
Similar to the AntibodyForests_node_transitions function, will calculate the incidence of features across undirected edges. In this case, each edge will be considered a unique species - with incidence counts across each unique feature value if a specific edge is connected to a node with that feature. Overlap metrics are then calculated for this edge-feature incidence matrix.
}
\examples{
\dontrun{
AntibodyForests_overlap(trees, group.by = 'seurat_clusters', method = 'jaccard')
}
}
