% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_clonotype.R
\name{GEX_clonotype}
\alias{GEX_clonotype}
\title{Platypus V2 GEX and VDJ integration for clonotypes}
\usage{
GEX_clonotype(GEX.object, VDJ.per.clone)
}
\arguments{
\item{GEX.object}{A single seurat object from automate_GEX function. This will likely be supplied as automate_GEX.output[[1]].}

\item{VDJ.per.clone}{Output from the VDJ_per_clone function. Each element in the list should be found in the output from the automate_GEX function.}
}
\value{
Returns a dataframe containing repertoire information, such as isotype, CDR sequences, mean number of UMIs. This output can be supplied to furhter packages VDJ_extract_sequences and VDJ_GEX_integrate
}
\description{
Platypus V2: Integrates VDJ and gene expression libraries by providing cluster membership seq_per_vdj object and the index of the cell in the Seurat RNA-seq object.
}
\examples{
\dontrun{
GEX_clonotype(GEX.object=automate.GEX.output[[1]], VDJ.per.clone=vdj.per.clone.output)
}

}
