% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_trajectories.R
\name{GEX_trajectories}
\alias{GEX_trajectories}
\title{This is a function which infers trajectories along ordered cells on dimensionality reduced data. It projects trajectrories on a dim. red. plot such as Umap. This uses Monocle3 or Monocle2.}
\usage{
GEX_trajectories(
  GEX,
  color.cells.by,
  reduction.method,
  cluster.method,
  genes,
  label.cell.groups,
  label.groups.by.cluster,
  labels.per.group,
  group.label.size,
  monocle.version,
  ordering.cells.method
)
}
\arguments{
\item{GEX}{GEX output of the VDJ_GEX_matrix function (VDJ_GEX_matrix[[2]]))}

\item{color.cells.by}{Column name in SummarizedExperiment::colData(GEX). To decide how the cells are colored in the output plot. E.g. color.cells.by = 'group_id' the cells will be colored based on their group_id.}

\item{reduction.method}{Which method to use for dimensionality reduction for monocle3. Supports "UMAP", "tSNE", "PCA" or "LSI". Default value is "UMAP".}

\item{cluster.method}{Monocle3 gives two clustering options: Using the Leiden or the Louvain algo. Default is louvain.}

\item{genes}{Takes a vector of genes (e.g. genes = c('CD3E', 'CD4', 'CD8A', 'CD44')) to highlight the expression of these genes in UMAP and in the trajectory plot in monocle3. Default is NULL.}

\item{label.cell.groups}{Whether to label cells in each group according to the most frequently occurring label(s) (as specified by color_cells_by) in the group. If false, plot_cells() simply adds a traditional color legend. Default is TRUE}

\item{label.groups.by.cluster}{Instead of labeling each cluster of cells, place each label once, at the centroid of all cells carrying that label. Default is TRUE}

\item{labels.per.group}{How many labels to plot for each group of cells. Default is 1}

\item{group.label.size}{Font size to be used for cell group labels. Default is 1}

\item{monocle.version}{Version of monocle. Either monocle2 or monocle3. Default is monocle3.}

\item{ordering.cells.method}{In monocle2 you can choose between selecting genes with high dispersion across cells for ordering cells along a trajectory (= 'high.dispersion'). Or order cells based on genes which differ between clusters, uses an unsupervised procedure called "dpFeature" (= 'differ.genes'). Defalut is "differ.genes"}
}
\value{
Returns a list.For monocle3: Element [[1]] returns a cell data set object with a new column for the UMAP clustering. This will be used for the GEX_pseudotime_trajectory_plot() function. [[2]] contains a plot of the clusters. [[3]] contains also a cluster plot but with the inferred trajectories. For monocle2: [[1]] cell data set object. [[2]] Trajetory plot with cells coloured based on their states (important to choose root state for pseudotime plot). [[3]] Trajectory plot based on color.cells.by
}
\description{
This is a function which infers trajectories along ordered cells on dimensionality reduced data. It projects trajectrories on a dim. red. plot such as Umap. This uses Monocle3 or Monocle2.
}
\examples{
\dontrun{

trajectory_output <- GEX_trajectories(GEX = vgm[[2]],
 reduction.method = "UMAP",
 color.cells.by = "group_id",
 labels_per_group = 2,
 group_label_size = 3)

 #visualizing gene expressions
 interesting_genes = c("Cxcr6", "Il7r")
 genes_trajectories <- GEX_trajectories(GEX = VGM$GEX,
  color.cells.by = "group_id",
   genes = interesting_genes)

##monocle2 ! DEPRECATED !
#trajectory_output <- GEX_trajectories(GEX = vgm[[2]],
#  monocle.version = "monocle2",
#  ordering.cells.method = "high.dispersion")
 }
}
