% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_call_MIXCR_full.R
\name{VDJ_call_MIXCR_full}
\alias{VDJ_call_MIXCR_full}
\title{MiXCR wrapper for Platypus V3 VDJ object. In addition to the VDJ_call_MIXCR function, the output also contains the concatenated sequences
from FR1 all the way to FR2 for both the VDJ and VJ.}
\usage{
VDJ_call_MIXCR_full(
  VDJ,
  mixcr.directory,
  species,
  platypus.version,
  operating.system,
  simplify
)
}
\arguments{
\item{VDJ}{For platypus.version = "v2" the output from the VDJ_per_clone function. This object should have information regarding the contigs and clonotype_ids for each cell. For platypus.version = "v3" the VDJ dataframe output of the VDJ_GEX_matrix function (VDJ.GEX.matri.output[[1]])}

\item{mixcr.directory}{The directory containing an executable version of MiXCR. FOR WINDOWS USERS THIS IS SET TO THE CURRENT WORKING DIRECTORY (please paste the content of the MIXCR folder after unzipping into your working directory. Make sure, that mixcr.jar is not within any subfolders.)}

\item{species}{Either "mmu" for mouse or "hsa" for human. These use the default germline genes for both species contained in MIXCR. Defaults to "hsa"}

\item{platypus.version}{Character. Defaults to "v3". Can be "v2" or "v3" dependent on the input format}

\item{operating.system}{Can be either "Windows", "Darwin" (for MAC) or "Linux". If left empty this is detected automatically}

\item{simplify}{Only relevant when platypus.version = "v3". Boolean. Defaults to TRUE. If FALSE the full MIXCR output and computed SHM column is appended to the VDJ If TRUE only the framework and CDR3 region columns and computed SHM column is appended. To discriminate between VDJ and VJ chains, prefixes are added to all MIXCR output columns}
}
\description{
Extracts information on the VDJRegion level using MiXCR on WINDOWS, MAC and UNIX systems for input from both Platypus v2 (VDJ.per.clone) or v3 (Output of VDJ_GEX_matrix) 
This function assumes the user can run an executable instance of MiXCR and is elgible to use MiXCR as determined by license agreements. 
! FOR WINDOWS USERS THE EXECUTABLE MIXCR.JAR HAS TO PRESENT IN THE CURRENT WORKING DIRECTORY ! 
The VDJRegion corresponds to the recombined heavy and light chain loci starting from framework region 1 (FR1) and extending to frame work region 4 (FR4). 
This can be useful for extracting full-length sequences ready to clone and further calculating somatic hypermutation occurrences.
In addition to the VDJ_call_MIXCR function, the output also contains the concatenated sequences from FR1 all the way to FR2 for both the VDJ and VJ.
}
