% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_ordination.R
\name{VDJ_ordination}
\alias{VDJ_ordination}
\title{Performs ordination/dimensionality reduction for a species incidence matrix, depending on the species selected in the feature.columns parameter.}
\usage{
VDJ_ordination(
  VDJ,
  feature.columns,
  grouping.column,
  method,
  reduction.level,
  VDJ.VJ.1chain,
  umap.n.neighbours,
  tsne.perplexity
)
}
\arguments{
\item{VDJ}{VDJ dataframe output from the VDJ_GEX_matrix function.}

\item{feature.columns}{Character vector. One or more column names from the VDJ to indicate the unique species for the incidence/count matrix. if more than one column is provided (e.g. c("VDJ_cdr3s_aa","VJ_cdr3s_aa")) these columns will be pasted together before metric calculation.}

\item{grouping.column}{Character. Column name of a column to group the ordination by. This could be "sample_id" to reduce across each sample. Indicative of 'sites' in a typical community data matrix/incidence matrix used in community ecology analyses (species by sites).}

\item{method}{Character. The ordination method; choose from either: PCA - 'pca', t-SNE - 'tsne', UMAP - 'umap', PCOA/MDS - 'mds', DCA - 'dca'.}

\item{reduction.level}{Character. Whether to reduce across groups ('groups'), features/sequences ('features'), or both ('both').}

\item{VDJ.VJ.1chain}{Boolean defaults to TRUE. Whether to filter out aberrant cells (more than 1 VDJ or VJ chain).}

\item{umap.n.neighbours}{Integer. Control the t-SNE perplexity when method = 'tsne'.}

\item{tsne.perplexity}{Integrer. Defaults to 1}
}
\value{
Returns a ggplot with the ordination analysis performer across features, groups, or both
}
\description{
Performs ordination/dimensionality reduction for a species incidence matrix, depending on the species selected in the feature.columns parameter.
}
\examples{

#PCA dimensionality reduction across samples for CDRH3
plot <- VDJ_ordination(VDJ = Platypus::small_vgm[[1]],
,feature.columns = c("VDJ_cdr3s_aa"), grouping.column = "sample_id"
,method = "pca", reduction.level = 'groups')

}
