% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_gene_visualization.R
\name{GEX_gene_visualization}
\alias{GEX_gene_visualization}
\title{Visualization of marker expression in a data set or of predefined genes (B cells, CD4 T cells and CD8 T cells).}
\usage{
GEX_gene_visualization(
  GEX,
  gene_set,
  predefined_genes = c("B_cell", "CD4_T_cell", "CD8_T_cell"),
  group.by
)
}
\arguments{
\item{GEX}{GEX output of the VDJ_GEX_matrix function (VDJ_GEX_matrix[[2]])).}

\item{gene_set}{Character vector containing the markers of interest given by the user.}

\item{predefined_genes}{Character vector to chose between B_cell, CD4_T_cell, and CD8_T_cell.}

\item{group.by}{Character. Column name of vgm to group plots by}
}
\value{
Return a list. Element[[1]] is the feature plot of markers of interest or predefined genes. Element[[2]] is the dottile plot of markers of interest or predefined genes. Element[[3]] is the violin plot of markers of interest or predefined genes.
}
\description{
Visualization of marker expression in a data set or of predefined genes (B cells, CD4 T cells and CD8 T cells).
}
\examples{
GEX_gene_visualization(GEX = Platypus::small_vgm[[2]], predefined_genes = "B_cell")

}
