% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexPublic.R
\docType{methods}
\name{ReturnLoanOrders,PoloniexPublicAPI-method}
\alias{ReturnLoanOrders,PoloniexPublicAPI-method}
\title{Returns a list of loan offers and demands for a given currency.}
\usage{
\S4method{ReturnLoanOrders}{PoloniexPublicAPI}(theObject, currency = "BTC")
}
\arguments{
\item{theObject}{The object on which the function should be called}

\item{currency}{- a length-one character vector
Represents the currency for which loan information should be
fetched.}
}
\value{
A list containing two items. Each item is a dataframe
 containing the actual loan offers or demands information.
  eg list$offers / list$demands
   - rows: offers / demand "order book" entries.
   - columns: rate, amount, min.days, max.days
}
\description{
Returns a list of loan offers and demands for a given currency.
}
\examples{
poloniex.public <- PoloniexPublicAPI()
currency        <- "BTC"
loan.orders     <- ReturnLoanOrders(poloniex.public)
}
