% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexPublic.R
\name{ReturnTradeHistory}
\alias{ReturnTradeHistory}
\title{Returns the past 200 trades for a given market, or up to
50,000 trades inside a specified input date range interval.}
\usage{
ReturnTradeHistory(theObject, pair = "USDT_BTC", from = NULL, to = NULL)
}
\arguments{
\item{theObject}{The public client API object on which the function should be called.}

\item{pair}{length-one character vector - The currencypair
for which trade history information should be fetched.}

\item{from}{POSIXct (or NULL) - starting timestamp
for optional date range interval.
  if from != NULL: from must be < 'to' &
  from must be >= (to - 1 year)}

\item{to}{POSIXct (or NULL) - ending timestamp for optional
date range interval.}
}
\value{
an xts object containing historical trade information

 Rows    - Information for one specific trade.
 Columns - globalTradeID, tradeID, type, rate, amount, total

   if from == NULL:
     Receive information for last 200 trades before 'to'
   if to == NULL:
     Ending timestamp for daterange will be set to Sys.time()
}
\description{
Returns the past 200 trades for a given market, or up to
50,000 trades inside a specified input date range interval.
}
\examples{
Sys.setenv(tz = "UTC")
poloniex.public <- PoloniexPublicAPI()
pair   <- "BTC_NXT"
from   <- as.POSIXct("2017-02-01 00:00:00 UTC")
to     <- as.POSIXct("2017-02-02 00:00:00 UTC")

trades.data <- ReturnTradeHistory(theObject = poloniex.public,
                                  pair      = pair,
                                  from      = from,
                                  to        = to)

}
