% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/foreignAlleles.R
\name{foreignAlleles}
\alias{foreignAlleles}
\title{Identify foreign alleles}
\usage{
foreignAlleles(adata)
}
\arguments{
\item{adata}{data frame: the preprocessed allele data set
returned by either \code{\link{inputData}} or
\code{\link{preprocessData}}.}
}
\value{
A list, containing two data frames.  Data frame
\code{byLocus} summarises the foreign alleles found at each locus.
Data frame \code{byProgenyLocus} summarises the same alleles by
progeny and locus.  In this latter data frame, the code
\code{P.missing} indicates no alleles were present in the progeny
at this locus.
}
\description{
Identify 'foreign' alleles (alleles present in progeny, but not in
parents or other non-parental adults).  Note that
\code{foreignAlleles} does \emph{not} distinguish between
populations as indicated by the \code{popn} column of the allele
data frame.
}
\examples{
## Using the example dataset 'FR_Genotype':
data(FR_Genotype)

## Since we did not load this dataset using inputData(), we must
## first process it with preprocessData() before doing anything
## else:
gData <- preprocessData(FR_Genotype,
                        numLoci=7,
                        ploidy=4,
                        dataType="genotype",
                        dioecious=TRUE,
                        mothersOnly=TRUE)

head(gData)  ## Checked and Cleaned version of FR_Genotype

fAlleles <- foreignAlleles(gData)

## View foreign alleles detected at each locus:
fAlleles$byLocus

## View foreign alleles detected in each progeny, at each locus:
fAlleles$byProgenyLocus

## Both of these objects are data frames, hence can be written to file
## via, e.g., write.csv().
}
\author{
Alexander Zwart (alec.zwart at csiro.au)
}

