% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_power.R
\name{evaluate_power}
\alias{evaluate_power}
\title{Power of a design to estimate a parameter.}
\usage{
evaluate_power(
  poped.db,
  bpop_idx,
  h0 = 0,
  alpha = 0.05,
  power = 0.8,
  twoSided = TRUE,
  find_min_n = TRUE,
  fim = NULL,
  out = NULL,
  ...
)
}
\arguments{
\item{poped.db}{A poped database}

\item{bpop_idx}{Index for an unfixed population parameter (bpop) for 
which the power should be
evaluated for being different than the null hypothesis (h0).}

\item{h0}{The null hypothesized value for the parameter.}

\item{alpha}{Type 1 error.}

\item{power}{Targeted power.}

\item{twoSided}{Is this a two-sided test.}

\item{find_min_n}{Should the function compute the minimum n needed (given the
current design) to achieve the desired power?}

\item{fim}{Provide the FIM from a previous calculation}

\item{out}{provide output from a previous calculation (e.g.,
calc_ofv_and_fim, ...)}

\item{...}{Extra parameters passed to \code{\link{calc_ofv_and_fim}} and
\code{\link{get_rse}}}
}
\value{
A list of elements evaluating the current design including the power.
}
\description{
Evaluate the power of a design to estimate a parameter value different than
some assumed value (often the assumed value is zero). The power is calculated 
using the linear Wald test and the the design is defined in a poped database.
}
\examples{
# Folowing the examples presented in Retout, 2007

ff <- function(model_switch,xt,parameters,poped.db){
  with(as.list(parameters),{
    
    lambda1 <- lam1a
    if(TREAT==2) lambda1 <- lam1b
    
    y=log10(P1*exp(-lambda1*xt)+P2*exp(-lam2*xt))
    
    return(list(y=y,poped.db=poped.db))
  })
}

sfg <- function(x,a,bpop,b,bocc){
  parameters=c(P1=exp(bpop[1]+b[1]),
               P2=exp(bpop[2]+b[2]),
               lam1a=exp(bpop[3]+b[3]),
               lam1b=exp(bpop[3]+bpop[4]+b[3]),
               lam2=exp(bpop[5]+b[4]),
               TREAT=a[1])
  return(parameters) 
}
  

poped.db <- create.poped.database(ff_fun = ff,
                                  fg_fun = sfg,
                                  fError_fun = feps.add,
                                  bpop=c(P1=12, P2=8,
                                         lam1=-0.7,beta=0,lam2=-3.0),
                                  d=c(P1=0.3, P2=0.3,
                                      lam1=0.3,lam2=0.3), 
                                  sigma=c(0.065^2),
                                  groupsize=100,
                                  m=2,
                                  xt=c(1, 3, 7, 14, 28, 56),
                                  minxt=0,
                                  maxxt=100,
                                  a=list(c(TREAT=1),c(TREAT=2)))

plot_model_prediction(poped.db)
evaluate_design(poped.db)

poped.db_2 <- create.poped.database(poped.db,bpop=c(P1=12, P2=8,
                                      lam1=-0.7,beta=0.262,lam2=-3.0))

plot_model_prediction(poped.db_2)
evaluate_design(poped.db_2)

evaluate_power(poped.db_2,bpop_idx = 4)
}
\references{
\enumerate{ \item Retout, S., Comets, E., Samson, A., and Mentre,
  F. (2007). Design in nonlinear mixed effects models: Optimization using the
  Fedorov-Wynn algorithm and power of the Wald test for binary covariates.
  Statistics in Medicine, 26(28), 5162-5179.
  \url{https://doi.org/10.1002/sim.2910}. \item Ueckert, S., Hennig, S.,
  Nyberg, J., Karlsson, M. O., and Hooker, A. C. (2013). Optimizing disease
  progression study designs for drug effect discrimination. Journal of
  Pharmacokinetics and Pharmacodynamics, 40(5), 587-596.
  \url{https://doi.org/10.1007/s10928-013-9331-3}. }
}
\seealso{
Other evaluate_design: 
\code{\link{evaluate.fim}()},
\code{\link{evaluate_design}()},
\code{\link{get_rse}()},
\code{\link{model_prediction}()},
\code{\link{plot_efficiency_of_windows}()},
\code{\link{plot_model_prediction}()}
}
\concept{evaluate_design}
