% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Fst_dat}
\alias{Fst_dat}
\title{A genetic differentiation matrix and locality information for each population. This data was generated
by subsetting data of Farleigh et al., 2021.}
\format{
A list with two elements:
\describe{
\item{Fst_dat}{Data frame with three rows and three columns}
\item{Loc_dat}{Data frame containing the locality information for each population}

...
}
}
\source{
Farleigh, K., Vladimirova, S. A., Blair, C., Bracken, J. T., Koochekian, N., Schield, D. R., ... & Jezkova, T. (2021). The effects of climate and demographic history in shaping genomic variation across populations of the Desert Horned Lizard (Phrynosoma platyrhinos). Molecular Ecology, 30(18), 4481-4496.
}
\usage{
data(Fst_dat)
}
\description{
A symmetric matrix with estimated genetic differentiation (Fst) between 3 populations.
}
\examples{
data(Fst_dat)
Fst <- Fst_dat[[1]]
Loc <- Fst_dat[[2]]
\donttest{
Test <- Dif_Stats_Map(dat = Fst, pops = Loc,
neighbors = 2,
col = c('#fd8d3c','#fc4e2a','#e31a1c','#bd0026','#800026'),Lat_buffer = 1, Long_buffer = 1)}

Fstat_plot <- Pairwise_heatmap(dat = Fst, statistic = 'FST')

}
\keyword{datasets}
