% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mppop_predict.R
\name{mppop.predict}
\alias{mppop.predict}
\alias{mppop_predict2}
\title{Predict genetic variance and genetic correlations in multi-parent populations
using a deterministic equation.}
\usage{
mppop.predict(
  G.in,
  y.in,
  map.in,
  crossing.table,
  parents,
  n.parents = 4,
  tail.p = 0.1,
  self.gen = 10,
  DH = FALSE,
  models = c("rrBLUP", "BayesA", "BayesB", "BayesC", "BL", "BRR"),
  n.core = 1,
  ...
)

mppop_predict2(
  M,
  y.in,
  marker.effects,
  map.in,
  crossing.table,
  parents,
  n.parents = 4,
  tail.p = 0.1,
  self.gen = 10,
  DH = FALSE,
  models = c("rrBLUP", "BayesA", "BayesB", "BayesC", "BL", "BRR"),
  n.core = 1,
  ...
)
}
\arguments{
\item{G.in}{See \code{G.in} in \code{\link[PopVar]{pop.predict}}.}

\item{y.in}{See \code{y.in} in \code{\link[PopVar]{pop.predict}}.}

\item{map.in}{See \code{map.in} in \code{\link[PopVar]{pop.predict}}.}

\item{crossing.table}{A \code{data.frame} with 2 columns (for bi-parental crosses) or 4 columns (for four-way crosses), each of which contains the names of parents to use in a potential cross. Rows contain individual crosses. See Details.}

\item{parents}{See \code{parents} in \code{\link[PopVar]{pop.predict}}.}

\item{n.parents}{Integer number of parents per cross. May be 2 or 4. If \code{crossing.table} is passed,
this argument is ignored.}

\item{tail.p}{See \code{tail.p} in \code{\link[PopVar]{pop.predict}}.}

\item{self.gen}{The number of selfing generations in the potential cross. Can be an integer or \code{Inf} for
recombinant inbreds. Note: \code{self.gen = 1} corresponds to an F2 population.}

\item{DH}{Indicator if doubled-haploids are to be induced after the number of selfing generations indicated by
\code{self.gen}. For example, if \code{self.gen = 0} and \code{DH = TRUE}, then doubled-haploids are assumed
to be induced using gametes from F1 plants.}

\item{models}{See \code{models} in \code{\link[PopVar]{pop.predict}}.}

\item{n.core}{Number of cores for parallelization. Parallelization is supported
only on a Linux or Mac OS operating system; if working on a Windows system, the function
is executed on a single core.}

\item{...}{Additional arguments to pass depending on the choice of \code{model}.}

\item{M}{A Matrix of marker genotypes of dimensions \code{nLine} x \code{nMarker}, coded as
-1, 0, and 1.}

\item{marker.effects}{A data frame of marker effects. The first column should include the marker name and
subsequent columns should include the marker effects. Supercedes \code{y.in} if passed.}
}
\value{
A \code{data.frame} containing predictions of \eqn{\mu}, \eqn{V_G}, and \eqn{\mu_{sp}} for
each trait for each potential multi-parent cross. When multiple traits are provided, the correlated
responses and correlation between all pairs of traits is also returned.
}
\description{
Predicts the genotypic mean, genetic variance, and
usefulness criterion (superior progeny mean) in a set of multi-parent populations
using marker effects and a genetic map. If more than two traits are specified,
the function will also return predictions of the genetic correlation in the population
and the correlated response to selection.
}
\details{
Predictions are based on the deterministic equations specified by Allier et al. (2019).

In the case of four-way crosses (i.e. 4 parents), the function assumes that the first two parents are mated,
producing a \eqn{F_1} offspring; then, the next two parents are mated, producing another \eqn{F_1} offspring.
The two \eqn{F_1} offspring are then mated and inbreeding or doubled haploid induction (if specified) proceeds
from there. For example, say cross \emph{i} uses parents P1, P2, P3, and P4. P1 and P2 are first mated,
producing O1; then, P3 and P4 are mated, producing O2; then, O1 and O2 are mated, producing a segregating family.

The \code{mppop.predict} function takes similarly formatted arguments as the \code{\link[PopVar]{pop.predict}} function
in the \code{PopVar} package. For the sake of simplicity, we also include the \code{mppop_predict2} function, which
takes arguments in a format more consistent with other genomewide prediction packages/functions.

If you select a \code{model} other than "rrBLUP", you must specify the following additional arguments:
\itemize{
\item{\code{nIter}: See \code{\link[PopVar]{pop.predict}}}.
\item{\code{burnIn}: See \code{\link[PopVar]{pop.predict}}}.
}
}
\examples{
\donttest{

# Load data
data("think_barley")

# Vector with 8 parents
parents <- sample(y.in_ex$Entry, 8)

# Create a crossing table with four parents per cross
cross_tab <- as.data.frame(t(combn(x = parents, m = 4)))
names(cross_tab) <- c("parent1", "parent2", "parent3", "parent4")

out <- mppop_predict2(M = G.in_ex_mat, y.in = y.in_ex, map.in = map.in_ex, 
                      crossing.table = cross_tab, models = "rrBLUP")

}




}
\references{
Allier, A., L. Moreau, A. Charcosset, S. Teyssèdre, and C. Lehermeier, 2019 Usefulness Criterion and Post-selection Parental
Contributions in Multi-parental Crosses: Application to Polygenic Trait Introgression. G3 (Bethesda) 9: 1469–1479.
https://doi.org/https://doi.org/10.1534/g3.119.400129
}
