/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openfast.DateValue;
import org.openfast.ScalarValue;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;
import org.openfast.template.type.codec.TypeCodec;

public class DateType
extends Type {
    private static final long serialVersionUID = 1L;
    private TypeCodec dateCodec;
    private DateFormat dateFormatter;

    public DateType(String dateFormat, TypeCodec dateCodec) {
        this(new SimpleDateFormat(dateFormat), dateCodec);
    }

    public DateType(DateFormat dateFormat, TypeCodec dateCodec) {
        super("date");
        this.dateFormatter = dateFormat;
        this.dateCodec = dateCodec;
    }

    public ScalarValue getDefaultValue() {
        return new DateValue(new Date(0L));
    }

    public boolean isValueOf(ScalarValue previousValue) {
        return previousValue instanceof DateValue;
    }

    public TypeCodec getCodec(Operator operator, boolean optional) {
        return this.dateCodec;
    }

    public ScalarValue getValue(String value) {
        if (value == null) {
            return ScalarValue.UNDEFINED;
        }
        try {
            return new DateValue(this.dateFormatter.parse(value));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(ScalarValue value) {
        return this.dateFormatter.format(((DateValue)value).value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateCodec == null ? 0 : this.dateCodec.hashCode());
        result = 31 * result + (this.dateFormatter == null ? 0 : this.dateFormatter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateType other = (DateType)obj;
        if (this.dateCodec == null ? other.dateCodec != null : !this.dateCodec.equals(other.dateCodec)) {
            return false;
        }
        return !(this.dateFormatter == null ? other.dateFormatter != null : !this.dateFormatter.equals(other.dateFormatter));
    }
}

