/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.InputStream;
import java.util.Date;
import org.openfast.DateValue;
import org.openfast.IntegerValue;
import org.openfast.ScalarValue;
import org.openfast.template.type.codec.TypeCodec;
import org.openfast.util.Util;

public class DateInteger
extends TypeCodec {
    private static final long serialVersionUID = 1L;

    public ScalarValue decode(InputStream in) {
        long longValue = TypeCodec.UINT.decode(in).toLong();
        int year = (int)(longValue / 10000L);
        int month = (int)((longValue - (long)(year * 10000)) / 100L);
        int day = (int)(longValue % 100L);
        return new DateValue(Util.date(year, month, day));
    }

    public byte[] encodeValue(ScalarValue value) {
        Date date = ((DateValue)value).value;
        int intValue = Util.dateToInt(date);
        return TypeCodec.UINT.encode(new IntegerValue(intValue));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

