/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openfast.DecimalValue;
import org.openfast.Global;
import org.openfast.IntegerValue;
import org.openfast.NumericValue;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.LongValue;
import org.openfast.template.type.codec.TypeCodec;

final class NullableSingleFieldDecimal
extends TypeCodec {
    private static final long serialVersionUID = 1L;

    NullableSingleFieldDecimal() {
    }

    public byte[] encodeValue(ScalarValue v) {
        if (v == ScalarValue.NULL) {
            return TypeCodec.NULL_VALUE_ENCODING;
        }
        ByteArrayOutputStream buffer = Global.getBuffer();
        DecimalValue value = (DecimalValue)v;
        try {
            if (Math.abs(value.exponent) > 63) {
                Global.handleError(FastConstants.R1_LARGE_DECIMAL, "");
            }
            buffer.write(TypeCodec.NULLABLE_INTEGER.encode(new IntegerValue(value.exponent)));
            buffer.write(TypeCodec.INTEGER.encode(new LongValue(value.mantissa)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer.toByteArray();
    }

    public ScalarValue decode(InputStream in) {
        ScalarValue exp = TypeCodec.NULLABLE_INTEGER.decode(in);
        if (exp == null || exp.isNull()) {
            return null;
        }
        int exponent = ((NumericValue)exp).toInt();
        long mantissa = ((NumericValue)TypeCodec.INTEGER.decode(in)).toLong();
        DecimalValue decimalValue = new DecimalValue(mantissa, exponent);
        return decimalValue;
    }

    public ScalarValue fromString(String value) {
        return new DecimalValue(Double.parseDouble(value));
    }

    public ScalarValue getDefaultValue() {
        return new DecimalValue(0.0);
    }

    public boolean isNullable() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

