/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.template.exchange;

import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.IntegerValue;
import org.openfast.Message;
import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.session.SessionControlProtocol_1_1;
import org.openfast.session.template.exchange.AbstractFieldInstructionConverter;
import org.openfast.session.template.exchange.ConversionContext;
import org.openfast.template.ComposedScalar;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.LongValue;
import org.openfast.template.Scalar;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.operator.Operator;
import org.openfast.util.Util;

public class ComposedDecimalConverter
extends AbstractFieldInstructionConverter {
    public Field convert(GroupValue fieldDef, TemplateRegistry templateRegistry, ConversionContext context) {
        QName name = new QName(fieldDef.getString("Name"), fieldDef.getString("Ns"));
        boolean optional = fieldDef.getBool("Optional");
        Operator exponentOperator = Operator.NONE;
        ScalarValue exponentDefaultValue = ScalarValue.UNDEFINED;
        Operator mantissaOperator = Operator.NONE;
        ScalarValue mantissaDefaultValue = ScalarValue.UNDEFINED;
        if (fieldDef.isDefined("Exponent")) {
            GroupValue exponentDef = fieldDef.getGroup("Exponent");
            GroupValue exponentOperatorDef = exponentDef.getGroup("Operator").getGroup(0);
            exponentOperator = ComposedDecimalConverter.getOperator(exponentOperatorDef.getGroup());
            if (exponentDef.isDefined("InitialValue")) {
                exponentDefaultValue = new IntegerValue(exponentDef.getInt("InitialValue"));
            }
        }
        if (fieldDef.isDefined("Mantissa")) {
            GroupValue mantissaDef = fieldDef.getGroup("Mantissa");
            GroupValue mantissaOperatorDef = mantissaDef.getGroup("Operator").getGroup(0);
            mantissaOperator = ComposedDecimalConverter.getOperator(mantissaOperatorDef.getGroup());
            if (mantissaDef.isDefined("InitialValue")) {
                mantissaDefaultValue = new LongValue(mantissaDef.getInt("InitialValue"));
            }
        }
        ComposedScalar composedDecimal = Util.composedDecimal(name, exponentOperator, exponentDefaultValue, mantissaOperator, mantissaDefaultValue, optional);
        if (fieldDef.isDefined("AuxId")) {
            composedDecimal.setId(fieldDef.getString("AuxId"));
        }
        return composedDecimal;
    }

    public GroupValue convert(Field field, ConversionContext context) {
        ComposedScalar composedScalar = (ComposedScalar)field;
        Message message = new Message(SessionControlProtocol_1_1.COMP_DECIMAL_INSTR);
        ComposedDecimalConverter.setNameAndId(field, message);
        message.setInteger("Optional", field.isOptional() ? 1 : 0);
        GroupValue exponentDef = this.createComponent(composedScalar.getFields()[0], "Exponent");
        GroupValue mantissaDef = this.createComponent(composedScalar.getFields()[1], "Mantissa");
        if (exponentDef != null) {
            message.setFieldValue("Exponent", (FieldValue)exponentDef);
        }
        if (mantissaDef != null) {
            message.setFieldValue("Mantissa", (FieldValue)mantissaDef);
        }
        return message;
    }

    private GroupValue createComponent(Scalar component, String componentName) {
        Group componentGroup = SessionControlProtocol_1_1.COMP_DECIMAL_INSTR.getGroup(componentName);
        GroupValue componentDef = new GroupValue(componentGroup);
        GroupValue componentOperatorDef = ComposedDecimalConverter.createOperator(component);
        if (componentOperatorDef == null) {
            return null;
        }
        GroupValue componentOperatorGroup = new GroupValue(componentGroup.getGroup("Operator"));
        componentDef.setFieldValue("Operator", (FieldValue)componentOperatorGroup);
        componentOperatorGroup.setFieldValue(0, (FieldValue)componentOperatorDef);
        if (!component.getDefaultValue().isUndefined()) {
            componentDef.setInteger("InitialValue", component.getDefaultValue().toInt());
        }
        return componentDef;
    }

    public boolean shouldConvert(Field field) {
        return field.getClass().equals(ComposedScalar.class);
    }

    public Group[] getTemplateExchangeTemplates() {
        return new Group[]{SessionControlProtocol_1_1.COMP_DECIMAL_INSTR};
    }
}

