/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.operator;

import org.openfast.Global;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.Scalar;
import org.openfast.template.operator.Operator;
import org.openfast.template.operator.OperatorCodec;
import org.openfast.template.type.Type;

public abstract class OptionallyPresentOperatorCodec
extends OperatorCodec {
    private static final long serialVersionUID = 1L;

    protected OptionallyPresentOperatorCodec(Operator operator, Type[] types) {
        super(operator, types);
    }

    public ScalarValue decodeEmptyValue(ScalarValue priorValue, Scalar field) {
        if (priorValue == ScalarValue.UNDEFINED) {
            return this.getInitialValue(field);
        }
        return this.getEmptyValue(priorValue);
    }

    public ScalarValue getValueToEncode(ScalarValue value, ScalarValue priorValue, Scalar field) {
        if (value != null) {
            return this.getValueToEncode(value, priorValue, field.getDefaultValue());
        }
        if (field.isOptional()) {
            if (priorValue == ScalarValue.UNDEFINED && !field.getDefaultValue().isUndefined() || priorValue != ScalarValue.UNDEFINED && priorValue != null) {
                return ScalarValue.NULL;
            }
        } else {
            Global.handleError(FastConstants.D6_MNDTRY_FIELD_NOT_PRESENT, "The field \"" + field + " is not present.");
        }
        return null;
    }

    protected abstract ScalarValue getValueToEncode(ScalarValue var1, ScalarValue var2, ScalarValue var3);

    protected abstract ScalarValue getInitialValue(Scalar var1);

    protected abstract ScalarValue getEmptyValue(ScalarValue var1);
}

