% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{limit_positions}
\alias{limit_positions}
\title{Limit the number of positions in a selection matrix}
\usage{
limit_positions(
  selection_df,
  max_positions,
  ranking_signal = NULL,
  verbose = FALSE
)
}
\arguments{
\item{selection_df}{Binary selection matrix}

\item{max_positions}{Maximum number of positions allowed}

\item{ranking_signal}{DataFrame with values for ranking (if NULL, selections are random)}

\item{verbose}{Print information about position limiting (default: FALSE)}
}
\value{
Selection matrix with at most max_positions securities selected per period
}
\description{
This function enforces position limits, keeping only the top N securities
when more are selected.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, 12)
# Create a selection of top 30 stocks
my_selections <- filter_top_n(momentum, 30)
# Limit to 20 positions, ranked by momentum
concentrated <- limit_positions(my_selections, 20, momentum)
# Limit to 10 positions, keeping existing selections randomly
limited <- limit_positions(my_selections, 10)
}
