% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_top_n_where}
\alias{filter_top_n_where}
\title{Select Top N from Qualified Stocks}
\usage{
filter_top_n_where(
  signal_df,
  n,
  condition_df,
  min_qualified = 1,
  ascending = FALSE
)
}
\arguments{
\item{signal_df}{Signal values for ranking}

\item{n}{Number to select}

\item{condition_df}{Binary matrix of qualified stocks}

\item{min_qualified}{Minimum qualified stocks required (default: 1)}

\item{ascending}{FALSE for highest, TRUE for lowest}
}
\value{
Binary selection matrix
}
\description{
Selects top N stocks by signal, but only from those meeting a condition.
Combines qualification and ranking in one step.
}
\examples{
data("sample_prices_weekly")
# Calculate indicators
momentum <- calc_momentum(sample_prices_weekly, 12)
ma20 <- calc_moving_average(sample_prices_weekly, 20)
distance_from_ma <- calc_distance(sample_prices_weekly, ma20)

# Top 10 momentum stocks from those above MA
above_ma <- filter_above(distance_from_ma, 0)
top_qualified <- filter_top_n_where(momentum, 10, above_ma)
}
