% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTAllparts.R
\name{PrInDTAllparts}
\alias{PrInDTAllparts}
\title{Conditional inference trees (ctrees) based on consecutive parts of the full sample}
\usage{
PrInDTAllparts(datain, classname, ctestv=NA, conf.level=0.95, thres=0.5,
       nesvar, divt)
}
\arguments{
\item{datain}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{classname}{Name of class variable (character)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
{see function \code{\link{PrInDT}} for details.}\cr
If no restrictions exist, the default = NA is used.}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical between 0 and 1); default = 0.95}

\item{thres}{Probability threshold for prediction of smaller class; default = 0.5}

\item{nesvar}{Name of nesting variable (character)}

\item{divt}{Number of parts of nesting variable nesvar for which models should be determined individually}
}
\value{
\describe{
\item{baAll}{balanced accuracy of tree on full sample}
\item{nesvar}{name of nesting variable}
\item{divt}{number of consecutive parts of the sample}
\item{badiv}{balanced accuracy of trees on 'divt' consecutive parts of the sample}
}
}
\description{
ctrees based on the full sample of the smaller class and consecutive parts of the larger class of the nesting variable 'nesvar'. 
The variable 'nesvar' has to be part of the data frame 'datain'.\cr   
  Interpretability is checked (see 'ctestv'); probability threshold can be specified.

\strong{Reference}\cr Weihs, C., Buschfeld, S. 2021b. NesPrInDT: Nested undersampling in PrInDT. 
arXiv:2103.14931
}
\details{
Standard output can be produced by means of \code{print(name)} or just \code{ name } where 'name' is the output data 
frame of the function.
}
\examples{
data <- PrInDT::data_speaker
data <- na.omit(data)
nesvar <- "SPEAKER"
outNesAll <- PrInDTAllparts(data,"class",ctestv=NA,conf.level=0.95,thres=0.5,nesvar,divt=8)
outNesAll

}
