% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTMulevALL.R
\name{PrInDTMulevAll}
\alias{PrInDTMulevAll}
\title{Conditional inference tree (ctree) for multiple classes on all observations}
\usage{
PrInDTMulevAll(datain, classname, ctestv=NA, conf.level=0.95)
}
\arguments{
\item{datain}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{classname}{Name of class variable (character)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
{see function \code{\link{PrInDT}} for details.}\cr
If no restrictions exist, the default = NA is used.}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical between 0 and 1)\cr
(default = 0.95)}
}
\value{
\describe{
\item{treeall}{ctree based on all observations}
\item{baAll}{balanced accuracy of 'treeall'}
\item{interpAll}{criterion of interpretability of 'treeall' (TRUE / FALSE)}
\item{confAll}{confusion matrix of 'treeall'}
}
}
\description{
ctree for more than 2 classes on all observations. Interpretability is checked (see 'ctestv').
}
\details{
Standard output can be produced by means of \code{print(name)} or just \code{ name } as well as \code{plot(name)} where 'name' is the output data 
frame of the function.
}
\examples{
datastrat <- PrInDT::data_zero
data <- na.omit(datastrat)
ctestv <- rbind('ETH == {C2a,C1a}', 'MLU == {1, 3}')
data$rel[data$ETH \%in\% c("C1a","C1b","C1c") & data$real == "zero"] <- "zero1"
data$rel[data$ETH \%in\% c("C2a","C2b","C2c") & data$real == "zero"] <- "zero2"
data$rel[data$real == "realized"] <- "real"
data$rel <- as.factor(data$rel) # rel is new class variable
data$real <- NULL # remove old class variable
conf.level <- 0.99 # 1 - significance level (mincriterion) in ctree
outAll <- PrInDTMulevAll(data,"rel",ctestv,conf.level) 
outAll # print model based on all observations
plot(outAll)

}
