% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{matched_index}
\alias{matched_index}
\title{Providing the ratio of number of matched values from the indicated column to the number of all available values from this column}
\usage{
matched_index(data, period1, period2, type = "prodID", interval = FALSE)
}
\arguments{
\item{data}{The user's data frame. It must contain a column \code{time} (as Date in format: year-month-day,e.g. '2020-12-01') and also a column indicated by the \code{type} parameter.}

\item{period1}{The first period (as character) limited to the year and month, e.g. "2019-03".}

\item{period2}{The second period (as character) limited to the year and month, e.g. "2019-04".}

\item{type}{This parameter defines the column which is used in the procedure. Possible values of the \code{type} parameter are: \code{retID}, \code{prodID}, \code{codeIN}, \code{codeOUT} or \code{description}.}

\item{interval}{A logical parameter indicating whether the procedure is to work for the whole time period between \code{period1} and \code{period2} (then it is TRUE).}
}
\value{
The function returns a ratio of number of values from the indicated column that occur simultaneously in the compared periods or in a given time interval to the number of all available values from the above-mentioned column (defined by the \code{type} parameter) at the same time. Possible values of the \code{type} parameter are: \code{retID}, \code{prodID} or \code{description}. If the \code{interval} parameter is set to FALSE, then the function compares only periods defined by \code{period1} and \code{period2}. Otherwise the whole time period between \code{period1} and \code{period2} is considered. The returned value belongs to [0,1].
}
\description{
The function returns a ratio of number of values from the indicated column that occur simultaneously in the compared periods or in a given time interval to the number of all available values from the above-mentioned column (defined by the \code{type} parameter) at the same time.
}
\examples{
\donttest{matched_index(milk, period1="2018-12", period2="2019-12", interval=TRUE)}
matched_index(milk, period1="2018-12", period2="2019-12", type="retID")
}
