% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{prior}
\alias{prior}
\title{prior}
\usage{
prior(drug.el, p0, gamma = 0.7, times = 100)
}
\arguments{
\item{drug.el}{A edge list of drugs, which is a two-column matrix, each row defines one edge. Numbers in the edge list represent NSC-ID of drugs.}

\item{p0}{A vector of approved drugs' NSC-ID of interested cancer.}

\item{gamma}{gamma = 0.7(default). A probability of losing when doing Random Walk. On the contray, there is a probability of 1-gamma left to itself. The range of this value is (0, 1).}

\item{times}{times = 100(default). Loop times when getting p-values.}
}
\value{
Detailed information about drug prioritizing, which contain NSC-id, name, prioritizing score, p-value, FDR, status and MOA(mechanism of action) of drugs.
}
\description{
This function is used to generate drug prioritizing result.
}
\examples{
e <- getData("drug.edgelist")
brc <- getData("breast_cancer")
\donttest{result <- prior(e, brc,time=20)}
}
