% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{find.signature.genes}
\alias{find.signature.genes}
\title{Find the signature genes for each group of cell/spots}
\usage{
find.signature.genes(
  seu,
  distce.assay = "distce",
  ident = NULL,
  expr.prop.cutoff = 0.1,
  assay = NULL,
  genes.use = NULL
)
}
\arguments{
\item{seu}{a Seurat object with coembedding in the reductions slot wiht component name reduction.}

\item{distce.assay}{an optional character, specify the assay name that constains distance matrix beween cells/spots and features, default as `distce` (distance of coembeddings).}

\item{ident}{an optional character in columns of metadata,  specify the group of cells/spots. Default as NULL, use Idents as the group.}

\item{expr.prop.cutoff}{an optional postive real ranging from 0 to 1,  specify cutoff of expression proportion of  features, default as 0.1.}

\item{assay}{an optional character,  specify the assay in seu, default as NULL, representing the default assay in seu.}

\item{genes.use}{an optional string vector, specify genes as the signature candidates.}
}
\value{
return a list with each component a data.frame object having two columns: `distance` and `expr.prop`.
}
\description{
Find the signature genes for each group of cell/spots based on coembedding distance and expression ratio.
}
\details{
In each data.frame object of the returned value, the row.names are gene names, and these genes are sorted by decreasing order of `distance`. User can define the signature genes as top n genes in distance and that the `expr.prop` larger than a cutoff. We set the cutoff as 0.1.
}
\examples{
library(Seurat)
data(pbmc3k_subset)
pbmc3k_subset <- pdistance(pbmc3k_subset, reduction='ncfm')
df_list_rna <- find.signature.genes(pbmc3k_subset)

}
\references{
None
}
\seealso{
None
}
