% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_candidate_by_name.R
\name{get_candidate_by_name}
\alias{get_candidate_by_name}
\title{Get Candidate Info}
\usage{
get_candidate_by_name(NAME, cycle = 2018, page = 1, myAPI_Key)
}
\arguments{
\item{NAME}{The first or last name of the candidate.}

\item{cycle}{The election cycle}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves federal candidates by last name, using a query string parameter.
}
\description{
https://www.propublica.org/datastore/apis
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/candidates/search
}
\examples{
\donttest{
get_candidate_by_name('Wilson', 2016)
}

}
