% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recent_bills_by_type.R
\name{recent_bills_by_type}
\alias{recent_bills_by_type}
\title{Get Recent Bills}
\usage{
recent_bills_by_type(
  congress,
  chamber = c("house", "senate", "both"),
  type = c("introduced", "updated", "active", "passed", "enacted", "vetoed"),
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{congress}{105-116}

\item{chamber}{house, senate or both}

\item{type}{introduced (introduced_date), updated (latest_major_action_date), active (latest_major_action_date)
passed (latest_major_action_date), enacted (enacted), vetoed (vetoed).}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
summaries of the 20 most recent bills by type. The order of the results depends on the value of type and all results are sorted in descending order.
}
\description{
For the current Congress, “recent bills” can be one of four types (see the descriptions below).
For previous Congresses, “recent bills” means the last 20 bills of that Congress. In the responses,
an active value of true means that the bill has seen action beyond introduction and committee referral.
Requests include a chamber value; to get recent bills from the House and Senate, use both as the value.
You can paginate through bills using the page-parameter that accepts multiples of 20.
Bills before the 113th Congress (prior to 2013) have fewer attribute values than those from the 113th
Congress onward, because the more recent bill data comes from the bulk data provided by the Government
Publishing Office. The order of the results depends on the value of type and all results are sorted in
descending order.
}
\examples{
\dontrun{
recent_bills_by_type(115, 'house', 'introduced')
}
}
