% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro.sgpv.R
\name{pro.sgpv}
\alias{pro.sgpv}
\title{pro.sgpv function}
\usage{
pro.sgpv(x, y, stage = c(1, 2))
}
\arguments{
\item{x}{Independent variables, can be a \code{matrix} or a \code{data.frame}}

\item{y}{Dependent variable, can be a \code{vector} or a column from a \code{data.frame}}

\item{stage}{Algorithm indicator. 1 denotes the one-stage algorithm and
2 denotes the two-stage algorithm. Default is 1.}
}
\value{
A list of following components:
\describe{
\item{var.index}{A vector of indices of selected variables}
\item{var.label}{A vector of labels of selected variables}
\item{lambda}{Cross-validated lambda in the two-stage algorithm. \code{NULL} for the one-stage algorithm}
\item{x}{Input data \code{x}}
\item{y}{Input data \code{y}}
}
}
\description{
This function outputs the variable selection results
from either one-stage algorithm or two-stage algorithm.
}
\examples{

# load the package
library(ProSGPV)

# prepare the data
x <- t.housing[, -ncol(t.housing)]
y <- t.housing$V9

# run one-stage algorithm
out.sgpv.1 <- pro.sgpv(x = x, y = y, stage = 1)

# More examples at https://github.com/zuoyi93/ProSGPV
}
\seealso{
\itemize{
\item \code{\link[=print.sgpv]{print.sgpv()}} prints the variable selection results
\item \code{\link[=coef.sgpv]{coef.sgpv()}} extracts coefficient estimates
\item \code{\link[=summary.sgpv]{summary.sgpv()}} summarizes the OLS outputs
\item \code{\link[=predict.sgpv]{predict.sgpv()}} predicts the outcome
\item \code{\link[=plot.sgpv]{plot.sgpv()}} plots variable selection results
}
}
