% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02PTCell.r
\name{effect}
\alias{effect}
\alias{effect,PTCell-method}
\alias{effect<-}
\alias{effect<-,PTCell,character-method}
\title{Extract or replace effect/trigger codes}
\usage{
\S4method{effect}{PTCell}(x)

\S4method{effect}{PTCell,character}(x) <- value
}
\arguments{
\item{x}{A \code{PTCell} from which the effect code needs to be extracted.}

\item{value}{A \code{character} string containing a three hexadecimal digit
effect code. All hexadecimal codes are accepted, not all will produce
meaningful effects.}
}
\value{
For \code{effect}, a \code{character} string with the three hexadecimal
digit effect code will be returned.

For \code{effect<-}, a copy of object \code{x} with effect code \code{value}
will be returned.
}
\description{
The 3 right-hand symbols of a \code{character} representation of a
\code{\link{PTCell}} represent an effect or trigger code. This method
can be used to extract or replace this code.
}
\details{
When a \code{\link{PTCell}} is represented by a \code{character} string,
the last three symbols represent a hexadecimal effect or trigger code.
In general the first of the three symbols indicates a type of effect or
trigger, whereas the latter two generally indicate a magnitude or a
position for effects and triggers.

Effects can for instance be volume or frequency slides. The codes can
also affect the module tempo or cause position jumps.

When replacing this code, all three digit hexadecimal \code{character}
strings are accepted, although not all codes will represent a valid
effect or trigger. See
\url{http://coppershade.org/articles/More!/Topics/Protracker_Effect_Commands/}
for a valid list of effect codes.
}
\examples{
data("mod.intro")

## the PTCell in row #1, of pattern #1, track #1
## has effect code "A08", which is a volume slide down (0xA)
## with speed 0x8:
effect(PTCell(mod.intro, 1, 1, 1))

## this is how you can change an effect:
cell <- PTCell("C-2 01 000")
effect(cell) <- "C20"

## the above expression sets the volume (effect 0xC)
## to 50\% (0x20 which is halve of the maximum 0x40)
}
\seealso{
Other cell.operations: 
\code{\link{PTCell-class}},
\code{\link{PTCell-method}},
\code{\link{note}()},
\code{\link{sampleNumber}()}
}
\author{
Pepijn de Vries
}
\concept{cell.operations}
