% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/note.R
\name{pt2_note_to_period}
\alias{pt2_note_to_period}
\title{Get a corresponding period value from a note string}
\usage{
pt2_note_to_period(note, empty_char = "-", finetune = 0, ...)
}
\arguments{
\item{note}{A \code{character} string representing notes (see also \code{\link[=pt2_note]{pt2_note()}}).}

\item{empty_char}{A \code{character} that is used to represent empty values.}

\item{finetune}{ProTracker used \code{integer} \code{finetune} values to tweak the playback rate.
it should be in the range of \code{-8}, up to \code{+7}.}

\item{...}{Ignored.}
}
\value{
Returns a \code{vector} of \code{integer} period values.
}
\description{
Back in the days, ProTracker was hardware driven on a Commodore Amiga. It made
advantage of a custom chipset where each chip had specific tasks. One of the chips
(named Paula) could play 8 bit audio samples stored in memory directly to one of
the four audio channels. On that chip you could set the integer 'period' value which is
inversely related to the sample rate at which the sample is played. Hence, it
defines the pitch of the sample. ProTracker used the period value to play different
notes. With this function you can convert a \code{character} string representing a
note to its corresponding period value used by Paula.
}
\examples{
pt2_note_to_period(c("A#2", "C-1"))
}
