% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell.R
\name{as_pt2cell}
\alias{as_pt2cell}
\alias{as_pt2celllist}
\title{Convert object into a pt2cell or pt2celllist class object}
\usage{
as_pt2cell(x, ...)

as_pt2celllist(x, ...)
}
\arguments{
\item{x}{A (\code{vector} of) \code{character} string(s), to be coerced to a
\code{pt2cell} class object. The first two or three characters represent
the note (see \code{pt2_note()}). this is followed by two numerical characters
representing the sample number. And finally three hexadecimal characters
representing an effect or trigger. These three parts can optionally be
padded with spaces. A valid string would for instance be \verb{"C#2 01 C1A}.}

\item{...}{Ignored}
}
\value{
An object of class \code{pt2cell}, \code{pt2celllist}.
}
\description{
Protracker uses pattern tables to annotate music progression.
Each cell in the table contains information about the note,
sample identifier and sound effect. This function coerces objects
to \code{pt2cell} or \code{pt2cell} class objects, such that they can be inserted into
patterns.
}
\examples{
as_pt2cell("A-3 02 121")
as_pt2cell("--- 01 000")
as_pt2celllist(c("A-3 02 121", "--- 01 000"))
}
