% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.profileLadder.R
\name{summary.profileLadder}
\alias{summary.profileLadder}
\title{Summary method for an object of the S3 class method \code{profileLadder}}
\usage{
\method{summary}{profileLadder}(object, plotOption = FALSE, ...)
}
\arguments{
\item{object}{an object of the class \code{profileLadder} -- i.e., either a
run-off triangle itself or the output form the \code{parallelReserve()} or
\code{mcReserve()} functions}

\item{plotOption}{logical to indicate whether a graphical output should be
also provided (set by DEFAULT to \code{FALSE}). If the incremental residuals
(standard or back-fitted) are provided within the object \code{x} the plot
provides a summary of the residuals (otherwise a simple barplot summarizing
the estimated reserve is given)}

\item{...}{not used}
}
\value{
Summary of the completed functional profiles and the estimated reserve
(provided by the function \code{parallelReserve()} or \code{mcReserve()}).
Summary of the incremental residuals (standard or backfitted) is also provided
if the residuals are available. The output is a list with the following items:
\item{origins}{a matrix with the row-specific summary of the completed
functional profiles (except the first fully developed profile---i.e., the first
row in the run-off triangle). The first column of the matrix (\code{First})
gives the first origin payments; The second column (\code{Latest}) gives
the last available (cumulative) payments (i.e., values from the last running
diagonal in the run-off triangle); The third column (\code{Dev.To.Date}) gives
a relative proportion of the paid amount (\code{Latest}) with respect to the
estimated ultimate (\code{Ultimate}) given in the fourth column; Finally, the
last column (\code{IBNR}) gives the estimated amount still left to pay (Incurred
But Not Reported)}
\item{overall}{Table with the summary of the true/estimated reserve:
\code{Paid amount} represents the sum of the last running diagonal;
\code{Estimated reserve} gives the reserve estimate provided by one of the
estimation algorithm (PARALLAX, REACT, or MACRAME); \code{True reserve} is
given as a sum of the last column (if available, \code{NA} otherwise); Finally,
some Accuracy in terms of \code{Reserve\%} is given as a percentage of the
estimated reserve with respect to the true reserve (see Maciak, Mizera, and
Pešta (2022) and \code{Dev.To.Date} gives the proportion of the overall
estimatd ultimate and the overall paid amount}
\item{resids}{Table with basic empirical description characteristics of the
residuals (standard or back-fitted) if the residuals are provided in \code{x}}
}
\description{
The function provides an overall summary of the output from the functions
parallelReserve() and mcReserve() (summary of the object of the class
\code{profileLadder})
}
\examples{
data(CameronMutual)
summary(CameronMutual)

## standard summary output
summary(mcReserve(CameronMutual))

## summary output with plotOption = TRUE
summary(mcReserve(CameronMutual), plotOption = TRUE)

## summary output with (standard) residuals and plotOption = TRUE
summary(mcReserve(CameronMutual, residuals = TRUE), plotOption = TRUE)

## summary output with (back-fitted) residuals and plotOption = TRUE
summary(mcReserve(observed(CameronMutual), residuals = TRUE), plotOption = TRUE)


}
\seealso{
\code{\link[=as.profileLadder]{as.profileLadder()}}, \code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}
}
