% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_local_network}
\alias{get_local_network}
\title{Extract the local networks from the PPI network.}
\usage{
get_local_network(network, freq_matrix, max.size = 500)
}
\arguments{
\item{network}{The PPI network.}

\item{freq_matrix}{The mutations matrix,generated by `get_mut_status`.}

\item{max.size}{The size of maximum connected local network,default is 500.}
}
\value{
local nerwork.
}
\description{
The function `get_local_network` is used to search local network of each gene by breadth-first algorithm.
}
\examples{
\donttest{#load the data
data(mut_status)
data(subnet)
#perform the function `get_local_network`.
localnetwork.example<-get_local_network(network=subnet,freq_matrix=mut_status,max.size=500)}
}
