% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{get_lollipopPlot}
\alias{get_lollipopPlot}
\title{Draw an lollipopPlot for module genes}
\usage{
get_lollipopPlot(
  maf,
  gene,
  AACol = NULL,
  labelPos = NULL,
  labPosSize = 0.9,
  showMutationRate = TRUE,
  showDomainLabel = TRUE,
  cBioPortal = FALSE,
  refSeqID = NULL,
  proteinID = NULL,
  roundedRect = TRUE,
  repel = FALSE,
  collapsePosLabel = TRUE,
  showLegend = TRUE,
  legendTxtSize = 0.8,
  labPosAngle = 0,
  domainLabelSize = 0.8,
  axisTextSize = c(1, 1),
  printCount = FALSE,
  colors = NULL,
  domainAlpha = 1,
  domainBorderCol = "black",
  bgBorderCol = "black",
  labelOnlyUniqueDoamins = TRUE,
  defaultYaxis = FALSE,
  titleSize = c(1.2, 1),
  pointSize = 1.5
)
}
\arguments{
\item{maf}{The patients' somatic mutation data, which in MAF format.}

\item{gene}{Modular gene from final_candidate_module,generated by `get_final_candidate_module`.}

\item{AACol, labelPos, labPosSize, showMutationRate, showDomainLabel, cBioPortal, refSeqID, proteinID, roundedRect, repel, collapsePosLabel, showLegend, legendTxtSize, labPosAngle, domainLabelSize, axisTextSize, printCount, colors, domainAlpha, domainBorderCol, bgBorderCol, labelOnlyUniqueDoamins, defaultYaxis, titleSize, pointSize}{see \code{\link[maftools]{lollipopPlot}}}
}
\value{
No return value
}
\description{
Load the data in MAF format and draws an lollipopPlot.
}
\examples{
#load the data.
maffile<-system.file("extdata","maffile.maf",package="ProgModule")
#draw an lollipopPlot
get_lollipopPlot(maf=maffile,gene="TP53")
}
