% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std_diff.R
\name{std_diff}
\alias{std_diff}
\title{Compare weighted and unweighted (naive analysis) standardized difference}
\usage{
std_diff(
  data.in,
  data.in.unadj = NULL,
  trt,
  vars,
  indicator.var = "indicator",
  class.of.int = NULL,
  prob.names = NULL,
  return.levels = FALSE,
  subj.aggr = TRUE,
  usubjid.var = "USUBJID"
)
}
\arguments{
\item{data.in}{input data, patients in rows and variables in columns.
This could be an output from ipw_strata() or ps_match_strata().}

\item{data.in.unadj}{data set to use for the unadjusted analysis. For example, if PSM is used, the
adjusted analysis should be done on the matched population but the unadjusted analysis should be done on
the original population}

\item{trt}{(\code{string}) column name of the treatment variable. The variable is expected to be in \code{factor} format and the first level
will be considered as reference (control) arm when calculating summary statistics.}

\item{vars}{variables of interest. standardized difference of each variable \cr
listed here will be calculated.}

\item{indicator.var}{(\code{string}) column name of the strata indicator variable which must be numeric.
Assume arm1 has strata labeling and arm2 does not have strata labeling.
pts without strata labeling should be indicated as -1 (e.g. pts in the arm1, or pts in arm2 but with missing label).
within arm1 (the arm with strata labeling), subclasss should be indicated as 0,1,2...}

\item{class.of.int}{(\code{list}) classes (stratum) of interest. Request to be in list format.
It could be subset of classes in arm1; it could also define combined classes.
For example: class.of.int = list("class1"=0, "class2"=1, "class3"=2, "class2or3"="c(1,2)").
for "class2or3", Prob(class 2 or 3) will be calculated as Prob(class2) + Prob(class3)}

\item{prob.names}{column names for the probability scores to be used as weights.
The order of probnames should match the order of class.of.int.
if probnames is NULL, the function will assume that the probnames are
pred0, pred1, prod2, prod1or2 in the example in class.of.int.}

\item{return.levels}{whether to return levels of each factor within each class.}

\item{subj.aggr}{whether aggregate multiple entries from the same patients to one record}

\item{usubjid.var}{column name indiacts subjuect id}
}
\value{
return a \code{list}, each \code{list} element is a \code{data.frame}
containing absolute standardized difference for each variable.
}
\description{
Compare weighted and unweighted (naive analysis) standardized difference
}
\note{
Calculation from Austin and Stuart (2015)
}
\examples{
library(dplyr)
clinical_1 <- clinical \%>\% mutate( 
  indicator = case_when(
    STRATUM == "strata_1" ~ 0, 
    STRATUM == "strata_2" ~ 1,
    is.na(STRATUM) & ARM == "experimental" ~ 1,
    TRUE ~ -1 
  ),
  ARM  = factor(ARM, levels = c("control","experimental")),
  BNLR = case_when(
    is.na(BNLR) ~ median(BNLR, na.rm = TRUE),
    TRUE ~ BNLR
  )
)
ipw_res1 <- ipw_strata(
  data.in = clinical_1, formula = indicator ~ BECOG + SEX + BNLR,
  indicator.var = "indicator", tte = "OS_MONTH", event = "OS_EVENT", trt = "ARM",
  class.of.int = list("strata_1" = 1, "strata_2" = 0)
 )
 std_diff(
  data.in = ipw_res1$data, vars = c("BECOG", "SEX", "BNLR"),
  indicator.var = "indicator", trt = "ARM",
  class.of.int = list("strata_1" = 1, "strata_2" = 0),
  usubjid.var = "SUBJID"
)
}
