% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{lasso_multi_back}
\alias{lasso_multi_back}
\title{Lasso regression with backtraking line research for multinomial response variable}
\usage{
lasso_multi_back(data,y,x,lambda,max_step=10000,image=FALSE,fista=TRUE,tol=10^-7,ini=0)
}
\arguments{
\item{data}{name of the dataset}

\item{y}{name of the dependent variables}

\item{x}{name of the independent variable}

\item{lambda}{a vector of lambda-value to be evaluated in the regression}

\item{max_step}{maximum number of steps}

\item{image}{plots the evolution of errors in term of lambda values}

\item{fista}{fista=TRUE: use FISTA algortihm for the multiclass logistic regression; fista=FALSE: use ISTA algortihm}

\item{tol}{tolerance for the convergence}

\item{ini}{initial value for the coefficients, default is 0
#'@examples
library(glmnet)
data("MultinomialExample")
x<-MultinomialExample$x
y<-MultinomialExample$y
mult<-as.data.frame(cbind(x,y))
lasso_multi_back(mult,y="y",x=colnames(mult)[-31],max_step = 1000,lambda=0.01,image=TRUE,fista=TRUE,ini=0)}
}
\value{
A list containing:
\itemize{
  \item{\code{coefficients}: A matrix where each column represents the estimated regression coefficients for a different lambda value.}
  \item{\code{error_evolution}: A numeric vector tracking the error at certain step.}
  \item{\code{num_steps}: An integer vector indicating the number of steps in which errors are calculated.}
}
}
\description{
the function carries out the Lasso regression for multinomial response using backtraking line research and FISTA/ISTA algorithm.
}
\details{
lasso_multi_back
}
