% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{as_wordvec}
\alias{as_wordvec}
\alias{as_embed}
\title{Reshape word vectors data between \code{wordvec} and \code{embed}.}
\usage{
as_wordvec(x, normalize = FALSE, verbose = TRUE)

as_embed(x, normalize = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{Object to be reshaped. See examples.}

\item{normalize}{Normalize all word vectors to unit length?
Defaults to \code{FALSE}. See \code{\link{data_wordvec_normalize}}.}

\item{verbose}{Print information to the console? Defaults to \code{TRUE}.}
}
\value{
\code{wordvec} (data.table) or \code{embed} (matrix).
}
\description{
Reshape word vectors data between
\code{wordvec} (data.table, with two variables \code{word} and \code{vec})
and \code{embed} (matrix, with dimensions as columns and words as row names).
}
\section{Functions}{
\itemize{
\item \code{as_wordvec()}: From \code{embed} (matrix) to \code{wordvec} (data.table).

\item \code{as_embed()}: From \code{wordvec} (data.table) to \code{embed} (matrix).

}}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = head(demodata, 10)

embed = as_embed(d)
embed

wordvec = as_wordvec(embed)
wordvec

}
\seealso{
\code{\link{data_transform}}

\code{\link{data_wordvec_load}}

\code{\link{data_wordvec_normalize}}

\code{\link{data_wordvec_subset}}
}
