% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{plot_wordvec_tSNE}
\alias{plot_wordvec_tSNE}
\title{Visualize word vectors with dimensionality reduced using t-SNE.}
\usage{
plot_wordvec_tSNE(
  x,
  dims = 2,
  perplexity,
  theta = 0.5,
  colors = NULL,
  seed = NULL,
  custom.Rtsne = NULL
)
}
\arguments{
\item{x}{Can be:
\itemize{
  \item{a \code{data.table} returned by \code{\link{get_wordvecs}}}
  \item{a \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table)
  or \code{\link[PsychWordVec:as_embed]{embed}} (matrix)
  loaded by \code{\link{data_wordvec_load}}}
}}

\item{dims}{Output dimensionality: \code{2} (default, the most common choice) or \code{3}.}

\item{perplexity}{Perplexity parameter, should not be larger than (number of words - 1) / 3.
Defaults to \code{floor((length(dt)-1)/3)} (where columns of \code{dt} are words).
See the \code{\link[Rtsne:Rtsne]{Rtsne}} package for details.}

\item{theta}{Speed/accuracy trade-off (increase for less accuracy), set to 0 for exact t-SNE.
Defaults to 0.5.}

\item{colors}{A character vector specifying (1) the categories of words (for 2-D plot only)
or (2) the exact colors of words (for 2-D and 3-D plot). See examples for its usage.}

\item{seed}{Random seed for reproducible results. Defaults to \code{NULL}.}

\item{custom.Rtsne}{User-defined \code{\link[Rtsne:Rtsne]{Rtsne}} object using the same \code{dt}.}
}
\value{
2-D: A \code{ggplot} object.
You may extract the data from this object using \code{$data}.

3-D: Nothing but only the data was invisibly returned,
because \code{\link[rgl:plot3d]{rgl::plot3d()}} is
"called for the side effect of drawing the plot"
and thus cannot return any 3-D plot object.
}
\description{
Visualize word vectors with dimensionality reduced
using the t-Distributed Stochastic Neighbor Embedding (t-SNE) method
(i.e., projecting high-dimensional vectors into a low-dimensional vector space),
implemented by \code{\link[Rtsne:Rtsne]{Rtsne::Rtsne()}}.
You should specify a random seed if you expect reproducible results.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = data_wordvec_normalize(demodata)

dt = get_wordvecs(d, cc("
  man, woman,
  king, queen,
  China, Beijing,
  Japan, Tokyo"))

## 2-D (default):
plot_wordvec_tSNE(dt, seed=1234)

plot_wordvec_tSNE(dt, seed=1234)$data

colors = c(rep("#2B579A", 4), rep("#B7472A", 4))
plot_wordvec_tSNE(dt, colors=colors, seed=1234)

\donttest{category = c(rep("gender", 4), rep("country", 4))
plot_wordvec_tSNE(dt, colors=category, seed=1234) +
  scale_x_continuous(limits=c(-200, 200),
                     labels=function(x) x/100) +
  scale_y_continuous(limits=c(-200, 200),
                     labels=function(x) x/100) +
  scale_color_manual(values=c("#B7472A", "#2B579A"))

## 3-D:
colors = c(rep("#2B579A", 4), rep("#B7472A", 4))
plot_wordvec_tSNE(dt, dims=3, colors=colors, seed=1)
}
}
\references{
Hinton, G. E., & Salakhutdinov, R. R. (2006).
Reducing the dimensionality of data with neural networks.
\emph{Science, 313}(5786), 504--507.

van der Maaten, L., & Hinton, G. (2008).
Visualizing data using t-SNE.
\emph{Journal of Machine Learning Research, 9}, 2579--2605.
}
\seealso{
\code{\link{plot_wordvec}}
}
