% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{tab_similarity}
\alias{tab_similarity}
\title{Tabulate cosine similarity/distance of word pairs.}
\usage{
tab_similarity(
  data,
  words = NULL,
  pattern = NULL,
  words1 = NULL,
  words2 = NULL,
  unique = FALSE,
  distance = FALSE
)
}
\arguments{
\item{data}{A \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix),
see \code{\link{data_wordvec_load}}.}

\item{words}{[Option 1] Character string(s).}

\item{pattern}{[Option 2] Regular expression (see \code{\link[stringr:str_subset]{str_subset}}).
If neither \code{words} nor \code{pattern} are specified (i.e., both are \code{NULL}),
then all words in the data will be extracted.}

\item{words1, words2}{[Option 3]
Two sets of words for only n1 * n2 word pairs. See examples.}

\item{unique}{Return unique word pairs (\code{TRUE})
or all pairs with duplicates (\code{FALSE}; default).}

\item{distance}{Compute cosine distance instead?
Defaults to \code{FALSE} (cosine similarity).}
}
\value{
A \code{data.table} of words, word pairs,
and their cosine similarity (\code{cos_sim})
or cosine distance (\code{cos_dist}).
}
\description{
Tabulate cosine similarity/distance of word pairs.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
tab_similarity(demodata, cc("king, queen, man, woman"))
tab_similarity(demodata, cc("king, queen, man, woman"),
               unique=TRUE)

tab_similarity(demodata, cc("Beijing, China, Tokyo, Japan"))
tab_similarity(demodata, cc("Beijing, China, Tokyo, Japan"),
               unique=TRUE)

## only n1 * n2 word pairs across two sets of words
tab_similarity(demodata,
               words1=cc("king, queen, King, Queen"),
               words2=cc("man, woman"))

}
\seealso{
\code{\link{cosine_similarity}}

\code{\link{pair_similarity}}

\code{\link{plot_similarity}}

\code{\link{most_similar}}

\code{\link{test_WEAT}}

\code{\link{test_RND}}
}
