% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-FMA.R
\name{method.FMA}
\alias{method.FMA}
\title{Fixed Effects Meta-Analysis Method}
\usage{
\method{method}{FMA}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (see Details)}
}
\value{
Data frame with FMA results
}
\description{
Implements the publication bias-unadjusted fixed effects meta-analysis.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"}}{T-distribution adjustment (\code{test = "t"})
and cluster robust standard errors with small-sample adjustment
(if converged, otherwise no small-sample adjustment or no cluster robust
standard errors) for fixed effects meta-analysis if
\code{study_ids} is specified in the data}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply FMA method
result <- run_method("FMA", data)
print(result)

}
\references{
\insertAllCited{}
}
