% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_events}
\alias{plot_events}
\title{Plot each event within a group to a directory}
\usage{
plot_events(data = data, Column = NULL, Grouping = "Subject",
  Nrow = 1, Ncol = 1, Device = "pdf", ...)
}
\arguments{
\item{data}{A data table object output by
\code{\link{ppl_select_recorded_eye}}.}

\item{Column}{A character string indicating the column to plot.}

\item{Grouping}{A character string indicating the column to serve as the
grouping. For example, "Subject" will use the subject identifier, producing
one image per subject containing all the events for that subject.}

\item{Nrow}{= A number specifying how many rows per page.}

\item{Ncol}{= A number specifying how many columns per page.}

\item{Device}{A character string indicating device type passed to
\code{ggsave}. By default, this is set to "pdf".}

\item{...}{Arguments to be passed to \code{ggsave}.}
}
\value{
Files containing plots.
}
\description{
\code{plot_events} plots each event in a group as a multi-panel plot and
saves it into specified directory.
}
\examples{
# Load example data
data("Pupilex3")

# Writing files to temporary folder for the example
plot_events(Pupilex3, Column = "Pupil", Device = "pdf",
            Grouping = "Subject", path = paste0(tempdir(),"/Figs"),
            Nrow = 1, Ncol = 1, width = 11, height = 8.5)

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Plotting", package="PupilPre")

}
